<?php
/* Constantas
---------------*/
    
    define('GLOBAX_ENOVATHEMES_TEMPPATH', get_template_directory_uri());
    define('GLOBAX_ENOVATHEMES_IMAGES', GLOBAX_ENOVATHEMES_TEMPPATH. "/images");
    define('ICL_DONT_LOAD_NAVIGATION_CSS', true);
    define('ICL_DONT_LOAD_LANGUAGE_SELECTOR_CSS', true);

    function globax_enovathemes_global_variables(){
        global $globax_enovathemes, $woocommerce, $post, $product, $wp_query, $query_string;
    }

/* Includes
---------------*/

    if (!class_exists('TGM_Plugin_Activation') && file_exists( get_template_directory() . '/includes/class-tgm-plugin-activation.php' ) ) {
        require_once(get_template_directory() . '/includes/class-tgm-plugin-activation.php');
    }

    if (defined( 'WPB_VC_VERSION' )) {
        require_once(get_template_directory() . '/includes/enovathemes_vc.php' );
    }

    require_once(get_template_directory() . '/includes/enovathemes-functions.php');
    require_once(get_template_directory() . '/includes/menu/custom-menu.php' );
    require_once(get_template_directory() . '/includes/dynamic-styles.php');
    
    if (class_exists('OCDI_Plugin')) {

        add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
        add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );

        function globax_enovathemes_intro_text( $default_text ) {
            $default_text = '<br><br><div class="ocdi__intro-text custom-intro-text">
            <h2 class="about-description">
            '.esc_html__( "Importing demo data (post, pages, images, theme settings, ...) is the easiest way to setup your theme.", "globax" ).'
            '.esc_html__( "It will allow you to quickly edit everything instead of creating content from scratch.", "globax" ).'
            </h2>
            <hr>
            <h3>'.esc_html__( "Important things to know before starting demo import", "globax" ).'</h3><br><br>
            <ul>
            <li>'.esc_html__( "No existing posts, pages, categories, images, custom post types or any other data will be deleted or modified.", "globax" ).'</li>
            <li>'.esc_html__( "Posts, pages, images, widgets, menus and other theme settings will get imported.", "globax" ).'</li>
            <li>'.esc_html__( "Please click on the Import button only once and wait, it can take a couple of minutes.", "globax" ).'</li>
            <li>'.esc_html__( "If you want to change the homepage version after import, do not import another demo, go to WordPress settings >> Reading and choose different homepage version as your front-page.", "globax" ).'</li>
            <li>'.esc_html__( "If you want to import pages/posts/custom post type/menu etc. separately use regular WordPress importer", "globax" ).'</li>
            <li>'.esc_html__( "Sometimes not all widgets are displayed after the import, this is known issue, you will need to replace these plugins or re-save one more time", "globax" ).'</li>
            </ul>
            <hr>
            <h3>'.esc_html__( "What to do after import", "globax" ).'</h3><br><br>
            <ul>
            <li>'.esc_html__( "After import don't forget to import Revolution Slider separately from Revolution Slider settings page", "globax" ).'</li>
            <li>'.esc_html__( "All the images will be imported with original sizes without cropping. This way your import process will be quicker and your server will have less work to do. After the import completed go to the WordPress >> Tools and use the Regenerate thumbnails plugin to crop images to theme supported sizes.", "globax" ).'</li>
            <li>'.esc_html__( "After import don't forget to choose footer from WordPress >> Footer >> Choose Footer", "globax" ).'</li>
            </ul>
            <hr>
            <h3>'.esc_html__( "Troubleshooting", "globax" ).'</h3><br>
            <p>'.esc_html__( "If you will have any issues with the import process, please update these option on your server (edit your php.ini file)", "globax" ).' </p>
            <ul class="code">
            <li>upload_max_filesize (256M)</li>
            <li>max_input_time (300)</li>
            <li>memory_limit (256M)</li>
            <li>max_execution_time (300)</li>
            <li>post_max_size (512M)</li>
            </ul>
            <p>'.esc_html__( "These defaults are not perfect and it depends on how large of an import you are making. So the bigger the import, the higher the numbers should be.", "globax" ).' </p>
            </div><br><br>';
            return $default_text;
        }
        add_filter( 'pt-ocdi/plugin_intro_text', 'globax_enovathemes_intro_text' );

        function globax_enovathemes_import_files() {
            return array(

                array(
                    'import_file_name'             => esc_html__('Main demo (full)', 'globax'),
                    'categories'                   => array( 'General' ),
                    'local_import_file'            => trailingslashit( get_template_directory() ) . '/demo/main/all.xml',
                    'local_import_widget_file'     => trailingslashit( get_template_directory() ) . '/demo/main/widgets.wie',
                    'local_import_redux'           => array(
                        array(
                            'file_path'   => trailingslashit( get_template_directory() ) . '/demo/main/options.json',
                            'option_name' => 'globax_enovathemes',
                        ),
                    ),
                    'import_preview_image_url'     => GLOBAX_ENOVATHEMES_TEMPPATH . '/demo/preview/main_all.jpg',
                    'import_notice'                => esc_html__( 'Import process can take up to 10 minutes, so please be patient and do not interrupt the import process', 'globax' ),
                    'preview_url'                  => 'http://enovathemes.com/globax/main/',
                ),

            );
        }
        add_filter( 'pt-ocdi/import_files', 'globax_enovathemes_import_files' );
    
        function globax_enovathemes_ocdi_after_import( $selected_import ) {

            if ( 'Main demo (full)' === $selected_import['import_file_name'] ) {

                // Set the homepage and blog page

                $home = get_page_by_title( 'Home' );
                $blog = get_page_by_title( 'Blog' );
                update_option( 'show_on_front', 'page' );
                update_option( 'page_on_front', $home->ID );
                update_option( 'page_for_posts', $blog->ID );

                $footer_settings = get_option( 'footer_settings');
                $footer_settings['footer_id'] = 3408;
                update_option( 'footer_settings', $footer_settings );

                // Set the navigation menus

                $header_menu_left  = get_term_by('name', 'Header import menu left part', 'nav_menu');
                $header_menu_right = get_term_by('name', 'Header import menu right part', 'nav_menu');
                $header_menu       = get_term_by('name', 'Header import menu', 'nav_menu');
                $top_menu          = get_term_by('name', 'Top menu', 'nav_menu');
                $one_page          = get_term_by('name', 'One page bullets', 'nav_menu');

                $locations = get_theme_mod('nav_menu_locations');

                $locations['header-menu-left']  = $header_menu_left->term_id;
                $locations['header-menu-right'] = $header_menu_right->term_id;
                $locations['header-menu']       = $header_menu->term_id;
                $locations['mobile-menu']       = $header_menu->term_id;
                $locations['top-menu']          = $top_menu->term_id;
                $locations['sidebar-menu']      = $header_menu->term_id;
                $locations['fullscreen-menu']   = $header_menu->term_id;
                $locations['bullets']           = $one_page->term_id;

                set_theme_mod( 'nav_menu_locations', $locations );

                // Remove unwanted menu

                $header_menu_left_remove  = get_term_by('name', 'Header menu left part', 'nav_menu');
                $header_menu_right_remove = get_term_by('name', 'Header menu right part', 'nav_menu');
                $header_menu_remove       = get_term_by('name', 'Header menu', 'nav_menu');

                wp_delete_nav_menu( $header_menu_left_remove->term_id );
                wp_delete_nav_menu( $header_menu_right_remove->term_id );
                wp_delete_nav_menu( $header_menu_remove->term_id );
                wp_delete_nav_menu( $mobile_menu_remove->term_id );

            }

            global $globax_enovathemes;

            if ( function_exists( 'wp_update_custom_css_post' ) ) {

                $wp_custom_css_styles = Redux::getOption('globax_enovathemes','custom-css');

                if (!empty($wp_custom_css_styles)) {
                    $core_css = wp_get_custom_css();
                    $return   =  wp_update_custom_css_post( $core_css . $wp_custom_css_styles );
                    if ( ! is_wp_error( $return ) ) {
                        Redux::setOption('globax_enovathemes','custom-css','');
                    }
                }
            }

            Redux::setOption('globax_enovathemes','disable-defaults',1);

        }
        add_action( 'pt-ocdi/after_import', 'globax_enovathemes_ocdi_after_import' );
    }

/* TGM
---------------*/
    
    add_action( 'tgmpa_register', 'globax_enovathemes_register_required_plugins' );
    function globax_enovathemes_register_required_plugins() {

        $plugins = array(

            array(
                'name'      => esc_html__('Contact Form 7', 'globax'),
                'slug'      => 'contact-form-7',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('One Click Demo Import', 'globax'),
                'slug'      => 'one-click-demo-import',
                'required'  => true
            ),
            array(
                'name'      => esc_html__('Regenerate Thumbnails', 'globax'),
                'slug'      => 'regenerate-thumbnails',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('Envato market master', 'globax'),
                'slug'      => 'envato-market',
                'source'    => get_template_directory() . '/plugins/envato-market.zip',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('WPBakery Visual Composer', 'globax'),
                'slug'      => 'js_composer',
                'source'    => get_template_directory() . '/plugins/js_composer.zip',
                'required'  => true,
                'version'   => '6.5'
            ),
            array(
                'name'      => esc_html__('Revolution slider', 'globax'),
                'slug'      => 'revslider',
                'source'    => get_template_directory() . '/plugins/revslider.zip',
                'required'  => true,
                'version'   => '6.3.9'
            ),
            array(
                'name'      => esc_html__('Enovathemes add-ons', 'globax'),
                'slug'      => 'enovathemes-addons',
                'source'    => get_template_directory() . '/plugins/enovathemes-addons.zip',
                'required'  => true,
                'version'   => '2.0'
            ),
            array(
                'name'      => esc_html__('Widgets in Menu for WordPress', 'globax'),
                'slug'      => 'widgets-in-menu',
                'required'         => false,
                'force_activation' => false,
                'has_notices'      => false,
                'dismissable'      => true,
            ),
            
        );

        $config = array(
            'id'                => 'globax',
            'default_path'      => '',                          // Default absolute path to pre-packaged plugins
            'parent_slug'       => 'themes.php',                // Default parent menu slug
            'capability'        => 'edit_theme_options',
            'menu'              => 'install-required-plugins',  // Menu slug
            'has_notices'       => true,                        // Show admin notices or not
            'dismissable'       => false,
            'is_automatic'      => false,                       // Automatically activate plugins after installation or not
            'message'           => '',                          // Message to output right before the plugins table
            'strings'           => array(
                'page_title'                                => esc_html__( 'Install Required Plugins', 'globax' ),
                'menu_title'                                => esc_html__( 'Install Plugins', 'globax' ),
                'installing'                                => esc_html__( 'Installing Plugin: %s', 'globax' ), // %1$s = plugin name
                'oops'                                      => esc_html__( 'Something went wrong with the plugin API.', 'globax' ),
                'notice_can_install_required'               => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'globax' ), // %1$s = plugin name(s)
                'notice_can_install_recommended'            => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'globax' ), // %1$s = plugin name(s)
                'notice_cannot_install'                     => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'globax' ), // %1$s = plugin name(s)
                'notice_can_activate_required'              => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'globax' ), // %1$s = plugin name(s)
                'notice_can_activate_recommended'           => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'globax' ), // %1$s = plugin name(s)
                'notice_cannot_activate'                    => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'globax' ), // %1$s = plugin name(s)
                'notice_ask_to_update'                      => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'globax' ), // %1$s = plugin name(s)
                'notice_cannot_update'                      => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'globax' ), // %1$s = plugin name(s)
                'install_link'                              => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'globax' ),
                'activate_link'                             => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'globax' ),
                'return'                                    => esc_html__( 'Return to Required Plugins Installer', 'globax' ),
                'plugin_activated'                          => esc_html__( 'Plugin activated successfully.', 'globax' ),
                'complete'                                  => esc_html__( 'All plugins installed and activated successfully. %s', 'globax' ), // %1$s = dashboard link
                'nag_type'                                  => 'updated' // Determines admin notice type - can only be 'updated' or 'error'
            )
        );

        tgmpa( $plugins, $config );

    }

/* Thumbnails
---------------*/

    if ( function_exists( 'add_theme_support' ) ) {

        add_theme_support( 'post-thumbnails');

        // Blog thumbnails
        add_image_size( 'globax_1200X640', 1200, 640, true );
        add_image_size( 'globax_870X440', 870, 440, true );
        add_image_size( 'globax_870X530', 870, 530, true );
        add_image_size( 'globax_588X440', 588, 440, true );
        add_image_size( 'globax_384X288', 384, 288, true );
        add_image_size( 'globax_282X212', 282, 212, true );

        // Grid based
        add_image_size( 'globax_282X282', 282, 282, true );
        add_image_size( 'globax_384X384', 384, 384, true );
        add_image_size( 'globax_588X588', 588, 588, true );

        // Wide screen
        add_image_size( 'globax_960X600', 960, 600, true );
        add_image_size( 'globax_640X400', 640, 400, true );
        add_image_size( 'globax_480X320', 480, 320, true );

        // Thumbnails
        add_image_size( 'globax_60X90', 60, 90, true );
        add_image_size( 'globax_144X144', 144, 144, true );

    }

    function globax_enovathemes_custom_image_sizes( $sizes ) {
        
        $new_sizes = array();
        
        $added_sizes = get_intermediate_image_sizes();

        foreach( $added_sizes as $key => $value) {
            $new_sizes[$value] = $value;
        }

        $new_sizes = array_merge( $new_sizes, $sizes );
        
        return $new_sizes;
    }
    add_filter('image_size_names_choose', 'globax_enovathemes_custom_image_sizes', 11, 1);


/* Theme Config
---------------*/

    add_action('init', 'globax_enovathemes_init');
    function globax_enovathemes_init() {
        add_theme_support( 'html5', array( 'gallery', 'caption' ) );
        add_theme_support( 'post-formats', array( 'aside', 'audio', 'video', 'gallery', 'link', 'quote', 'status', 'chat') );
        add_theme_support( 'automatic-feed-links' );
        add_post_type_support( 'post', 'post-formats' );
        add_post_type_support( 'page', 'excerpt' );
        add_theme_support( 'align-wide' );
        add_theme_support( 'responsive-embeds' );
    }

    if ( ! isset( $content_width ) ) {$content_width = 1200;}

    if(function_exists('vc_set_as_theme')) vc_set_as_theme(true);

    add_action( 'after_setup_theme', 'globax_enovathemes_woocommerce_support' );
    function globax_enovathemes_woocommerce_support() {
        add_theme_support( 'woocommerce' );
    }

    add_action('init', 'globax_enovathemes_page_excerpt');
    function globax_enovathemes_page_excerpt() {
        add_post_type_support( 'page', 'excerpt' );
    }

    add_action('after_setup_theme', 'globax_enovathemes_language_setup');
    function globax_enovathemes_language_setup(){
        load_theme_textdomain('globax', get_template_directory() . '/languages');
    }

    add_action( 'after_setup_theme', 'globax_enovathemes_theme_slug_setup' );
    function globax_enovathemes_theme_slug_setup() {
        add_theme_support( 'title-tag' );
    }

    function globax_enovathemes_remove_redux_news() {
        remove_meta_box( 'redux_dashboard_widget', 'dashboard', 'side' );
    } 
    add_action('wp_dashboard_setup', 'globax_enovathemes_remove_redux_news' );

    function globax_enovathemes_redux_menu_page_removing() {
        remove_submenu_page( 'tools.php', 'redux-about' );
    }
    add_action( 'admin_menu', 'globax_enovathemes_redux_menu_page_removing' );


    add_filter('body_class', 'globax_enovathemes_classes');
    function globax_enovathemes_classes($classes) {

            global $globax_enovathemes, $post;

            $et_img_preloader      = (isset($GLOBALS['globax_enovathemes']['img-preload']) && $GLOBALS['globax_enovathemes']['img-preload'] == 1) ? 'true' : 'false';
            $et_sidebar_navigation = (isset($GLOBALS['globax_enovathemes']['sidebar-navigation']) && $GLOBALS['globax_enovathemes']['sidebar-navigation'] == 1) ? "true" : "false";

            if ($et_sidebar_navigation == "true") {
                $GLOBALS['globax_enovathemes']['layout'] = "wide";
            }

            $custom_class = "enovathemes ";

            if ($et_img_preloader == "true") {
                $custom_class .= 'preloader-active ';
            } else {
                $custom_class .= 'preloader-inactive ';
            }

            $custom_class .= (isset($GLOBALS['globax_enovathemes']['custom-scroll']) && $GLOBALS['globax_enovathemes']['custom-scroll'] == 1) ? 'custom-scroll-true ' : 'custom-scroll-false ';
            $custom_class .= (isset($GLOBALS['globax_enovathemes']['layout']) && !empty($GLOBALS['globax_enovathemes']['layout']) ) ? 'layout-'.$GLOBALS['globax_enovathemes']['layout'].' ' : 'layout-wide ';
            $custom_class .= (isset($GLOBALS['globax_enovathemes']['sidebar-align']) && !empty($GLOBALS['globax_enovathemes']['sidebar-align']) ) ? 'sidebar-align-'.$GLOBALS['globax_enovathemes']['sidebar-align'].' ' : 'sidebar-align-right ';
            $custom_class .= (isset($GLOBALS['globax_enovathemes']['form-button-size']) && !empty($GLOBALS['globax_enovathemes']['form-button-size'])) ? "button-size-".$GLOBALS['globax_enovathemes']['form-button-size'].' ' : "button-size-medium ";

            if (class_exists('Woocommerce')){

                $wishlistpage = "false";
                if (defined('YITH_WCWL')) {
                    $wishlistpage = (is_page(get_option('yith_wcwl_wishlist_page_id'))) ? "true" : "false"; 
                }

                if (is_cart() || is_checkout()) {$custom_class .= " cart-checkout ";}
                if (is_account_page()) {$custom_class .= " my-account ";}
                if ($wishlistpage == "true"){$custom_class .= " wishlist-page ";}

                $woocommerce_shop_page_display = get_option( 'woocommerce_shop_page_display' );

                if ($woocommerce_shop_page_display === '') {
                    $custom_class .= " woocommerce-layout-product ";
                } elseif ($woocommerce_shop_page_display === 'subcategories') {
                    $custom_class .= " woocommerce-layout-category ";
                } elseif($woocommerce_shop_page_display === 'both') {
                    $custom_class .= " woocommerce-layout-both ";
                }

                if (class_exists('YITH_WCQV_Frontend')){

                    if (get_option('yith-wcqv-enable-mobile') == 'no') {
                        $custom_class .= " woocommerce-quick-view-no-mob ";
                    }

                }

            }

            if (is_page()) {
                $values        = get_post_custom( get_the_ID() );
                $blank         = (isset( $values['blank'][0]) && !empty($values['blank'][0])) ? $values["blank"][0] : 'false';
                $custom_class .= " blank-".$blank;
            }

            if (is_category() || is_tag() || is_day() || is_month() || is_year() || is_author() || is_home()) {
                $custom_class .= " blog-page";
            }

            $classes[] = $custom_class;
            return $classes;
    }

    function globax_enovathemes_woocommerce_page_container_before(){
        if (class_exists('Woocommerce')){

            $wishlistpage = "false";
            if (defined('YITH_WCWL')) {
                $wishlistpage = (is_page(get_option('yith_wcwl_wishlist_page_id'))) ? "true" : "false"; 
            }

            if (is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() || $wishlistpage == "true") {
                echo '<div class="product-layout product-container-boxed">';
            }
            
        }
    }
    add_action('globax_enovathemes_before_page_container', 'globax_enovathemes_woocommerce_page_container_before');
    
    function globax_enovathemes_page_comments(){
        if (class_exists('Woocommerce')){

            $add_comment_template = "true";

            $wishlistpage = "false";
            if (defined('YITH_WCWL')) {
                $wishlistpage = (is_page(get_option('yith_wcwl_wishlist_page_id'))) ? "true" : "false"; 
            }

            if (is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() || $wishlistpage == "true") {
                $add_comment_template = "false";
            }

            if ($add_comment_template == "true") {
                comments_template();
            }
            
        } else {

            $add_comment_template = "true";

            if ($add_comment_template == "true") {
                comments_template();
            }

        }
    }
    add_action('globax_enovathemes_after_page_body', 'globax_enovathemes_page_comments');
    

    function globax_enovathemes_woocommerce_page_container_after(){
        if (class_exists('Woocommerce')){

            $wishlistpage = "false";
            if (defined('YITH_WCWL')) {
                $wishlistpage = (is_page(get_option('yith_wcwl_wishlist_page_id'))) ? "true" : "false"; 
            }

            if (is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() || $wishlistpage == "true") {
                echo '</div>';
            }
            
        }
    }
    add_action('globax_enovathemes_after_page_container', 'globax_enovathemes_woocommerce_page_container_after');

    // Allow shortcodes in Contact Form 7 
    function globax_enovathemes_shortcodes_in_cf7( $form ) {
        $form = do_shortcode( $form );
        return $form;
    }
    add_filter( 'wpcf7_form_elements', 'globax_enovathemes_shortcodes_in_cf7' );

/* Menu
---------------*/

    function globax_enovathemes_register_menu() {

        register_nav_menus(
            array(
              'header-menu-left'  => esc_html__( 'Header menu left part', 'globax' ),
              'header-menu-right' => esc_html__( 'Header menu right part', 'globax' ),
              'header-menu'       => esc_html__( 'Header menu', 'globax' ),
              'mobile-menu'       => esc_html__( 'Mobile menu', 'globax' ),
              'top-menu'          => esc_html__( 'Top menu', 'globax' ),
              'sidebar-menu'      => esc_html__( 'Sidebar menu', 'globax' ),
              'fullscreen-menu'   => esc_html__( 'Fullscreen menu', 'globax' ),
              'bullets'           => esc_html__( 'Bullets for one page layout navigation', 'globax' ),
              'footer-menu'       => esc_html__( 'Footer menu', 'globax' ),
            )
        );

    }
    add_action( 'after_setup_theme', 'globax_enovathemes_register_menu' );

/* Widget areas
---------------*/

    add_action( 'widgets_init', 'globax_enovathemes_register_sidebars' );
    function globax_enovathemes_register_sidebars() {

        if ( function_exists( 'register_sidebar' ) ){

            global $globax_enovathemes;

            $custom_class = 'widget';

            register_sidebar( 
                array (
                'name'          => esc_html__( 'Blog widgets', 'globax'),
                'id'            => 'blog-widgets',
                'description'   => esc_html__('Add your blog widgets here. This is the main blog widget area. It is visible only in blog archive pages.', 'globax'),
                'class'         => 'blog-widgets',
                'before_widget' => '<div id="%1$s" class="'.$custom_class.' %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h5 class="widget_title">',
                'after_title'   => '</h5>' )
            );

            register_sidebar( 
                array (
                'name'          => esc_html__( 'Blog single post page widgets', 'globax'),
                'id'            => 'blog-single-widgets',
                'description'   => esc_html__('Add your blog single post widgets here. This widget area is only visible in the single post page.', 'globax'),
                'class'         => 'blog-single-widgets',
                'before_widget' => '<div id="%1$s" class="'.$custom_class.' %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h5 class="widget_title">',
                'after_title'   => '</h5>' )
            );

            register_sidebar( 
                array (
                'name'          => esc_html__( 'Shop widgets', 'globax'),
                'id'            => 'shop-widgets',
                'description'   => esc_html__('Add your shop widgets here. This widget area is visible in shop arhive pages only.', 'globax'),
                'class'         => 'shop-widgets',
                'before_widget' => '<div id="%1$s" class="'.$custom_class.' %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h5 class="widget_title">',
                'after_title'   => '</h5>' )
            );

            register_sidebar( 
                array (
                'name'          => esc_html__( 'Shop single post page widgets', 'globax'),
                'id'            => 'shop-single-widgets',
                'description'   => esc_html__('Add your shop single product widgets here. This widget area is only visible in single product page.', 'globax'),
                'class'         => 'shop-single-widgets',
                'before_widget' => '<div id="%1$s" class="'.$custom_class.' %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h5 class="widget_title">',
                'after_title'   => '</h5>' )
            );

            for ($i=1; $i < 7; $i++) { 
                register_sidebar( 
                    array (
                    'name'          => esc_html__( 'Page widgets #','globax').$i,
                    'id'            => 'page-'.$i,
                    'description'   => esc_html__('Use this widget area to display widgets in regulare pages.', 'globax'),
                    'class'         => 'page-widgets',
                    'before_widget' => '<div id="%1$s" class="'.$custom_class.' %2$s"><div class="widget-body">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h5 class="widget_title">',
                    'after_title'   => '</h5>' )
                );
            }

            $sidebar_custom_class = 'widget';

            register_sidebar( 
                array (
                'name'          => esc_html__( 'Sidebar widgets', 'globax'),
                'id'            => 'sidebar-widgets',
                'description'   => esc_html__('Add widgets to global site sidebar. It has toggle in header and is visible in all pages', 'globax'),
                'class'         => 'sidebar-widgets',
                'before_widget' => '<div id="%1$s" class="'.$sidebar_custom_class.' %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h5 class="widget_title">',
                'after_title'   => '</h5>' )
            );

            if (defined( 'YAWP_WIM_PREFIX' )) {
                unregister_sidebar( YAWP_WIM_PREFIX );

                $header_custom_class = 'widget';

                register_sidebar( array(
                    'name' => esc_html__( 'Menu widgets', 'globax' ),
                    'id' => YAWP_WIM_PREFIX,
                    'before_widget' => '<div class="menu-widgets"><div id="%1$s" class="'.$header_custom_class.' %2$s"><div class="widget-body">',
                    'after_widget'  => '</div></div></div>',
                    'before_title'  => '<h5 class="widget_title">',
                    'after_title'   => '</h5>' )
                );
            }

            $footer_custom_class = 'widget';
            $footer_form_styles = (isset($GLOBALS['globax_enovathemes']['footer-form-styles']) && $GLOBALS['globax_enovathemes']['footer-form-styles'] == 1) ? "true" : "false";

            for ($i=1; $i < 7; $i++) { 
                register_sidebar( 
                    array (
                    'name'          => esc_html__( 'Footer widgets #','globax').$i,
                    'id'            => 'footer-'.$i,
                    'description'   => esc_html__('Display widgets in footer area.', 'globax'),
                    'class'         => 'footer-widgets',
                    'before_widget' => '<div id="%1$s" class="'.$footer_custom_class.' %2$s"><div class="widget-body">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h5 class="widget_title">',
                    'after_title'   => '</h5>' )
                );
            }
        }   
    }

/* Woo Commerce
---------------*/

    if (class_exists('Woocommerce')){

        /* Show mini cart on cart and checkout
        ---------------*/

            add_filter( 'woocommerce_widget_cart_is_hidden', 'globax_enovathemes_always_show_cart', 40, 0 );
            function globax_enovathemes_always_show_cart() {
                return false;
            }

        globax_enovathemes_global_variables();

        add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
        if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
            add_action( 'init', 'globax_enovathemes_woo_img', 1 );
            function globax_enovathemes_woo_img() {
                $catalog = array(
                    'width'     => '588',
                    'height'    => '588',
                    'crop'      => 1
                );
                $single = array(
                    'width'     => '588',
                    'height'    => '588',
                    'crop'      => 1
                );
                $thumbnail = array(
                    'width'     => '144',
                    'height'    => '144',
                    'crop'      => 1 
                );
                update_option( 'shop_catalog_image_size', $catalog );
                update_option( 'shop_single_image_size', $single );
                update_option( 'globax_144X144_image_size', $thumbnail );
            }
        }

        add_filter('woocommerce_add_to_cart_fragments', 'globax_enovathemes_add_to_cart');
        function globax_enovathemes_add_to_cart( $fragments ) {
            
            global $woocommerce;

            ob_start(); ?>
            <a class="cart-contents" href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php echo esc_attr__('View your shopping cart', 'globax'); ?>">
                <span class="cart-title"><?php echo esc_html__('Cart','globax'); ?></span>
                <span class="cart-total"><?php echo html_entity_decode($GLOBALS['woocommerce']->cart->get_cart_total()); ?></span>
                <span class="cart-info"><?php echo esc_attr($GLOBALS['woocommerce']->cart->cart_contents_count); ?></span>
            </a>
            <?php

            $fragments['a.cart-contents'] = ob_get_clean();
            return $fragments;

        }

        function globax_enovathemes_category_class( $classes, $class, $category= null ){
            $classes[] = 'et-item post';
            return $classes;
        }
        add_filter( 'product_cat_class', 'globax_enovathemes_category_class', 10, 3 );

        add_action( 'init', 'globax_enovathemes_custom_placeholder' );
        function globax_enovathemes_custom_placeholder() {
            add_filter('woocommerce_placeholder_img_src', 'custom_woocommerce_placeholder_img_src');
            function custom_woocommerce_placeholder_img_src( $src ) {
                $src = GLOBAX_ENOVATHEMES_IMAGES . '/placeholder.jpg';
                return $src;
            }
        }

        remove_action( 'woocommerce_before_subcategory', 'woocommerce_template_loop_category_link_open', 10);
        remove_action( 'woocommerce_after_subcategory', 'woocommerce_template_loop_category_link_close', 10);

        remove_action( 'woocommerce_before_subcategory_title', 'woocommerce_subcategory_thumbnail', 10);
        add_action( 'woocommerce_before_subcategory_title', 'woocommerce_subcategory_thumbnail', 10);
        if ( ! function_exists( 'woocommerce_subcategory_thumbnail' ) ) {
            function woocommerce_subcategory_thumbnail( $category ) {

                global $globax_enovathemes;
                $product_container               = (isset($GLOBALS['globax_enovathemes']['product-container']) && $GLOBALS['globax_enovathemes']['product-container']) ? $GLOBALS['globax_enovathemes']['product-container'] : "boxed";
                $product_sidebar                 = (isset($GLOBALS['globax_enovathemes']['product-sidebar']) && $GLOBALS['globax_enovathemes']['product-sidebar']) ? $GLOBALS['globax_enovathemes']['product-sidebar'] : "none";
                $product_category_post_size      = (isset($GLOBALS['globax_enovathemes']['product-category-post-size']) && $GLOBALS['globax_enovathemes']['product-category-post-size']) ? $GLOBALS['globax_enovathemes']['product-category-post-size'] : "medium";
                $product_post_layout             = (isset($GLOBALS['globax_enovathemes']['product-post-layout']) && $GLOBALS['globax_enovathemes']['product-post-layout']) ? $GLOBALS['globax_enovathemes']['product-post-layout'] : "product-with-details";
                $product_image_effect            = (isset($GLOBALS['globax_enovathemes']['product-image-effect']) && $GLOBALS['globax_enovathemes']['product-image-effect']) ? $GLOBALS['globax_enovathemes']['product-image-effect'] : "overlay-none";
                
                $image                           = false;
                $thumbnail_id                    = get_woocommerce_term_meta( $category->term_id, 'thumbnail_id', true  );

                $thumb_size             = 'globax_384X384';
                $post_img_attr          = array();
                $post_img_sizes         = '100vw';
                $post_img_default_size  = $post_img_sizes;

                if ($product_post_layout == "grid") {
                    switch ($product_category_post_size) {
                        case 'small' :
                            $thumb_size            = 'globax_588X588';
                            $post_img_default_size = '588px';
                            $post_img_1024_size    = '588px';
                            $post_img_sizes        = '(max-width: 319px) 92vw, (max-width: 479px) 384px, (max-width: 767px) 588px, (max-width: 1023px) 384px, (max-width: 1279px) '.$post_img_1024_size.', '.$post_img_default_size;
                            break;
                        case 'medium':
                            $thumb_size            = ($product_container == "wide") ? 'globax_640X640' : 'globax_588X588';
                            $post_img_default_size = ($product_container == "wide") ? '640px' : '588px';
                            $post_img_sizes        = '(max-width: 319px) 92vw, (max-width: 479px) 384px, (max-width: 767px) 588px, (max-width: 1023px) 384px, (max-width: 1279px) 384px, '.$post_img_default_size;
                            break;
                        case 'large':
                            $thumb_size            = ($product_sidebar != "none") ? 'globax_588X588' : (($product_container == "wide") ? 'globax_960X600' : 'globax_588X588');
                            $post_img_default_size = ($product_sidebar != "none") ? '588px' : (($product_container == "wide") ? '960px' : '588px');
                            $post_img_1024_size    = ($product_sidebar != "none") ? '384px' : '588px';
                            $post_img_sizes        = '(max-width: 319px) 92vw, (max-width: 479px) 384px, (max-width: 767px) 384px, (max-width: 1023px) 384px, (max-width: 1279px) '.$post_img_1024_size.', '.$post_img_default_size;
                            break;
                    }
                }

                if ($thumbnail_id) {

                    $post_img_attr['alt'] = esc_attr($category->name);

                    $post_img_original = wp_get_attachment_image_src( $thumbnail_id, "full" );
                    $post_img_282  = get_the_post_thumbnail_url($thumbnail_id,'globax_282X282');
                    $post_img_384  = get_the_post_thumbnail_url($thumbnail_id,'globax_384X384');
                    $post_img_588  = get_the_post_thumbnail_url($thumbnail_id,'globax_588X588');
                    $post_img_640  = get_the_post_thumbnail_url($thumbnail_id,'globax_640X400');
                    $post_img_960  = get_the_post_thumbnail_url($thumbnail_id,'globax_960X600');

                    $post_img_srcset = "";


                    if (strpos($post_img_282[0], '282x')) {
                        $post_img_srcset .= $post_img_282[0].' 282w';
                    }

                    if (strpos($post_img_384[0], '384x')) {
                        $post_img_srcset .= ', '.$post_img_384[0].' 384w';
                    }

                    if (strpos($post_img_588[0], '588x')) {
                        $post_img_srcset .= ', '.$post_img_588[0].' 588w';
                    }

                    if (strpos($post_img_640[0], '640x')) {

                        $post_img_srcset .= ', '.$post_img_640[0].' 640w';
                    }

                    if (strpos($post_img_960[0], '960x')) {
                        $post_img_srcset .= ', '.$post_img_960[0].' 960w';
                    }

                    if (empty($post_img_srcset)) {
                        $post_img_srcset = $post_img_original[0].' '.$post_img_original[1].'w';
                        $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                    }

                    if ($product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                        $thumb_size = 'full';
                    }

                    if (empty($post_img_srcset) || $product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                        $post_img_srcset = $post_img_original[0].' '.$post_img_original[1].'w';
                        $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                    }

                    $post_img_attr['srcset'] = $post_img_srcset;
                    $post_img_attr['sizes']  = $post_img_sizes;

                    $image = wp_get_attachment_image($thumbnail_id,$thumb_size,false,$post_img_attr);
                }

                ?>

                
                    <div class="image-preloader"></div>
                    <?php if ($product_image_effect != "overlay-none"): ?>
                        <div class="post-image-overlay">
                            <a class="overlay-read-more" href="<?php echo get_term_link( $category->slug, 'product_cat' ); ?>" title="<?php echo esc_attr__("View ", 'globax').' '.esc_attr( $category->name ); ?>"></a>
                        </div>
                        <div class="image-container">
                            <?php if ($image): ?>
                                <?php echo wp_get_attachment_image($thumbnail_id,$thumb_size,false,$post_img_attr); ?>
                            <?php else: ?>
                                <?php echo wc_placeholder_img($thumb_size); ?>
                            <?php endif ?>
                        </div>
                    <?php else: ?>
                        <a href="<?php echo get_term_link( $category->slug, 'product_cat' ); ?>" title="<?php echo esc_attr__("View ", 'globax').' '.esc_attr( $category->name ); ?>">
                            <div class="image-container">
                                <?php if ($image): ?>
                                    <?php echo wp_get_attachment_image($thumbnail_id,$thumb_size,false,$post_img_attr); ?>
                                <?php else: ?>
                                    <?php echo wc_placeholder_img($thumb_size); ?>
                                <?php endif ?>
                            </div>
                        </a>
                    <?php endif ?>
                    
                    
                <?php
            }
        }

        remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10);
        add_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10);
        if ( ! function_exists( 'woocommerce_template_loop_category_title' ) ) {
            function woocommerce_template_loop_category_title( $category ) { ?>
                <h4 class="woocommerce-loop-category__title post-title">
                    <a href="<?php echo get_term_link( $category->slug, 'product_cat' ); ?>" title="<?php echo esc_attr__("View ", 'globax').' '.esc_attr( $category->name ); ?>">
                    <?php
                        echo esc_attr($category->name);
                        if ( $category->count > 0 ){
                            echo apply_filters( 'woocommerce_subcategory_count_html', ' <mark class="count">(' . $category->count . ')</mark>', $category );
                        }
                    ?>
                    </a>
                </h4>

            <?php }
        }

        function globax_enovathemes_before_subcategory(){ ?>
            <div class="post-inner et-item-inner et-clearfix">
                <div class="post-image post-media overlay-hover">
        <?php }
        add_filter( 'woocommerce_before_subcategory', 'globax_enovathemes_before_subcategory', 10, 2);

        function globax_enovathemes_after_subcategory(){ ?>     
            </div>
        <?php }
        add_filter( 'woocommerce_after_subcategory', 'globax_enovathemes_after_subcategory', 10, 2 );
                
        add_filter( 'woocommerce_before_subcategory_title', 'globax_enovathemes_before_subcategory_title', 10, 2 );
        function globax_enovathemes_before_subcategory_title(){ ?>
                </div>
                <div class="post-body et-clearfix">
                    <div class="post-body-inner-wrap">
                        <div class="post-body-inner">
        <?php }

        add_filter( 'woocommerce_after_subcategory_title', 'globax_enovathemes_after_subcategory_title', 10, 2 );
        function globax_enovathemes_after_subcategory_title(){ ?>
                        </div>
                    </div>
                </div>

        <?php }

        add_action('init', 'globax_enovathemes_single_product');
        function globax_enovathemes_single_product(){

            globax_enovathemes_global_variables();

            if (defined('THEME_PANEL')) {
                theme_panel_demo_configurations_woocommerce();
            }
            
            $product_single_sidebar          = (isset($GLOBALS['globax_enovathemes']['product-single-sidebar']) && $GLOBALS['globax_enovathemes']['product-single-sidebar']) ? $GLOBALS['globax_enovathemes']['product-single-sidebar'] : "right";
            $product_single_social           = (isset($GLOBALS['globax_enovathemes']['product-single-social']) && $GLOBALS['globax_enovathemes']['product-single-social'] == 1) ? "true" : "false";
            $product_single_post_layout      = (isset($GLOBALS['globax_enovathemes']['product-single-post-layout']) && !empty($GLOBALS['globax_enovathemes']['product-single-post-layout'])) ? $GLOBALS['globax_enovathemes']['product-single-post-layout'] : "single-product-tabs-under";

            // Single product
            remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
            remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20 );
            remove_action('woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );

            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );

            add_action( 'woocommerce_before_single_product_summary', 'globax_enovathemes_before_single_product_summary', 5, 2);
            function globax_enovathemes_before_single_product_summary(){ ?>
                <?php global $product; ?>
                <div class="single-product-content et-clearfix">
                    <div class="woocommerce-product-gallery et-clearfix">
                        <div class="woocommerce-product-gallery-inner et-clearfix">
                            <?php

                                global $product,$post,$globax_enovathemes;

                                $product_single_post_layout = (isset($GLOBALS['globax_enovathemes']['product-single-post-layout']) && !empty($GLOBALS['globax_enovathemes']['product-single-post-layout'])) ? $GLOBALS['globax_enovathemes']['product-single-post-layout'] : "single-product-tabs-under";
                                $product_image_original     = (isset($GLOBALS['globax_enovathemes']['product-image-original']) && $GLOBALS['globax_enovathemes']['product-image-original'] == 1) ? "true" : "false";

                                $post_img_attr          = array();
                                $attachment_ids         = $product->get_gallery_image_ids();
                                $shop_single_image_size = apply_filters( 'single_product_large_thumbnail_size', 'shop_single' );
                                $thumb_size             = (!empty($shop_single_image_size)) ? $shop_single_image_size : 'full';
                                $product_gallery_thumb  = 'globax_144X144';
                            
                                if ($product_single_post_layout == 'single-product-tabs-inside') {
                                    $product_gallery_thumb = 'globax_60X90';
                                }

                                if ($product_image_original == "true") {
                                    $shop_single_image_size = "full";
                                    $thumb_size             = "full";
                                }

                            ?>
                            <?php
                                if (defined('YITH_WCWL')){
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }
                            ?>
                            <?php $stock_status = $product->get_stock_status(); ?>
                            <?php if ($stock_status == "outofstock"): ?>
                                <div class="product-status outofstock"><span><?php echo esc_html__( 'Out of stock', 'globax' ) ?></span></div>
                            <?php else: ?>
                                <?php if ( $product->is_on_sale() ) : ?>
                                    <div class="product-status onsale"><span><?php echo esc_html__( 'Sale!', 'globax' ) ?></span></div>
                                <?php endif;?>
                            <?php endif ?>
                            <?php if (!empty($attachment_ids)): ?>
                                <div id="product-gallery" class="product-gallery post-media product-gallery-<?php echo esc_attr($post->ID); ?>">
                                    <ul id="product-gallery-set" class="slides et-clearfix carousel_thumb">
                                        
                                        <?php
                                            $post_featured_img                = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), $thumb_size);
                                            $post_featured_img_original       = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                                            $post_featured_img_sizes          = '(max-width: 479px) 92vw, (max-width: 1023px) '.$post_featured_img_original[1].'px, '.$post_featured_img[1].'px';
                                            $post_featured_img_srcset         = $post_featured_img_original[0].' '.$post_featured_img_original[1].'w';
                                            $post_featured_img_srcset         .= ', '.$post_featured_img[0].' '.$post_featured_img[1].'w';
                                            $post_featured_img_attr['srcset'] = $post_featured_img_srcset;
                                            $post_featured_img_attr['sizes']  = $post_featured_img_sizes;
                                            $post_featured_img_attr['alt']    = esc_html(get_the_title($post->ID));

                                            $product_gallery_attr = 'class="product-image-zoom photoswip-product" data-size="'.$post_featured_img_original[1].'x'.$post_featured_img_original[2].'"';
                                        ?>
                                        <?php if ($post_featured_img[0]): ?>
                                            <li class="product-featured-img">
                                                <div>
                                                    <a href="<?php echo esc_attr($post_featured_img_original[0]); ?>" <?php echo html_entity_decode($product_gallery_attr); ?>>
                                                        <?php echo wp_get_attachment_image( get_post_thumbnail_id($post->ID), $thumb_size,false,$post_featured_img_attr); ?>
                                                    </a>
                                                </div>
                                            </li>
                                        <?php endif ?>
                                        <?php foreach ( $attachment_ids as $attachment_id ) { ?>
                                            <li>
                                                <?php
                                                    $post_img                = wp_get_attachment_image_src($attachment_id, $thumb_size);
                                                    $post_img_original       = wp_get_attachment_image_src($attachment_id, 'full');
                                                    $post_img_sizes          = '(max-width: 479px) 92vw, (max-width: 1023px) '.$post_img_original[1].'px, '.$post_img[1].'px';
                                                    $post_img_srcset         = $post_img_original[0].' '.$post_img_original[1].'w';
                                                    $post_img_srcset         .= ', '.$post_img[0].' '.$post_img[1].'w';
                                                    $post_img_attr['srcset'] = $post_img_srcset;
                                                    $post_img_attr['sizes']  = $post_img_sizes;
                                                    $post_img_attr['alt']    = esc_html(get_the_title($post->ID));
                                                    $product_gallery_attr    = 'class="product-image-zoom photoswip-product" data-size="'.$post_img_original[1].'x'.$post_img_original[2].'"';
                                                ?>
                                                <div class="image-container">
                                                    <a href="<?php echo esc_url($post_img_original[0]); ?>" <?php echo html_entity_decode($product_gallery_attr); ?>>
                                                        <?php echo wp_get_attachment_image( $attachment_id, $thumb_size,false,$post_img_attr); ?>
                                                    </a>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>

                                <div id="product-gallery-navigation" class="product-gallery-navigation gallery-navigation slick-thumbnail-navigation">
                                    <ul id="product-gallery-navigation-set" class="slides et-clearfix">
                                        <li class="product-featured-thumbnail">
                                            <div class="image-container">
                                                <?php echo wp_get_attachment_image( get_post_thumbnail_id($post->ID), $product_gallery_thumb,false, ''); ?>
                                            </div>
                                        </li>
                                        <?php foreach ( $attachment_ids as $attachment_id ) { ?>
                                            <li>
                                                <div class="image-container">
                                                    <?php echo wp_get_attachment_image( $attachment_id, $product_gallery_thumb,false, ''); ?>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            <?php else: ?>
                                <?php
                                    $post_img                = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), $thumb_size);
                                    $post_img_original       = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                                    $post_img_sizes          = '(max-width: 479px) 92vw, (max-width: 1023px) '.$post_img_original[1].'px, '.$post_img[1].'px';
                                    $post_img_srcset         = $post_img_original[0].' '.$post_img_original[1].'w';
                                    $post_img_srcset         .= ', '.$post_img[0].' '.$post_img[1].'w';
                                    $post_img_attr['srcset'] = $post_img_srcset;
                                    $post_img_attr['sizes']  = $post_img_sizes;
                                    $post_img_attr['alt']    = esc_html(get_the_title($post->ID));
                                ?>
                                <?php if ($post_img[0]): ?>
                                    <div id="product-gallery" class="product-gallery post-media">
                                        <a href="<?php echo esc_attr($post_img_original[0]); ?>">
                                            <?php echo wp_get_attachment_image(get_post_thumbnail_id($post->ID), $thumb_size,false,$post_img_attr); ?>
                                        </a>
                                    </div>
                                <?php else: ?>
                                    <?php echo wc_placeholder_img($thumb_size); ?>  
                                <?php endif ?>
                            <?php endif ?>
                        </div>
                    </div>
            <?php }

            function globax_enovathemes_single_product_summary_start(){?>
                <?php global $product; ?>
                <div class="product-title-section">
                    <?php if ( $price_html = $product->get_price_html() ) : ?>
                        <span class="price stylish-dash"><?php echo html_entity_decode($price_html); ?></span>
                    <?php endif; ?>
                    <h1 class="post-title et-clearfix">
                        <span class="title-text"><?php the_title(); ?></span>
                        <!-- Rating -->
                        <?php 
                            if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) {
                                $rating = $product->get_average_rating();
                                $count  = 0;
                                $html = 0 < $rating ? '<span class="star-rating">' . wc_get_star_rating_html( $rating, $count ) . '</span>' : '';
                                echo apply_filters( 'woocommerce_product_get_rating_html', $html, $rating, $count );
                            }
                        ?>
                    </h1>
                </div>
            <?php }
            add_action( 'woocommerce_single_product_summary', 'globax_enovathemes_single_product_summary_start', 10);

            add_action( 'woocommerce_single_product_summary', 'globax_enovathemes_single_product_summary_description', 15);
            function globax_enovathemes_single_product_summary_description(){ ?>

                <h4 class="product-summary-title stylish-dash"><?php echo esc_html__('Short description', 'globax') ?></h4>

            <?php }

            add_action( 'woocommerce_product_meta_start', 'globax_enovathemes_single_product_summary_meta', 5);
            function globax_enovathemes_single_product_summary_meta(){ ?>

                <h4 class="product-summary-title stylish-dash"><?php echo esc_html__('Details', 'globax') ?></h4>

            <?php }

            add_action( 'woocommerce_after_single_product', 'globax_enovathemes_single_product_navigation', 15);
            function globax_enovathemes_single_product_navigation(){ ?>

                <?php globax_enovathemes_post_nav('product',get_the_ID()); ?>

            <?php }

            add_filter( 'woocommerce_after_single_product_summary', 'globax_enovathemes_after_single_product_summary', 5, 2 );
            function globax_enovathemes_after_single_product_summary(){ ?>
                </div>
            <?php }


            if ($product_single_social == "true") {
                add_filter( 'woocommerce_product_meta_end', 'globax_enovathemes_woocommerce_product_meta_end', 5, 2 );
                function globax_enovathemes_woocommerce_product_meta_end(){ ?>
                    <?php echo enovathemes_addons_post_social_share('post-social-share'); ?>
                <?php }
            }

        }

        add_action('init', 'globax_enovathemes_product_data_tabs');
        function globax_enovathemes_product_data_tabs(){

            global $globax_enovathemes;

            $data_shop = (isset($_GET["shop"]) && !empty($_GET["shop"])) ? $_GET["shop"] : "none";

            if ($data_shop == 'tabs_inside') {
                $GLOBALS['globax_enovathemes']['product-single-post-layout'] = 'single-product-tabs-inside';
            }

            $product_single_post_layout = (isset($GLOBALS['globax_enovathemes']['product-single-post-layout']) && !empty($GLOBALS['globax_enovathemes']['product-single-post-layout'])) ? $GLOBALS['globax_enovathemes']['product-single-post-layout'] : "single-product-tabs-under";

            if ($product_single_post_layout == "single-product-tabs-inside") {

                remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
                add_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 60 ); 
            }
        }

        remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
        add_action('woocommerce_after_single_product_summary', 'globax_enovathemes_upsell_display', 15 );
        function globax_enovathemes_upsell_display (){ ?>

            <?php

                global $post, $globax_enovathemes, $product;

                $product_image_effect     = (isset($GLOBALS['globax_enovathemes']['product-image-effect']) && !empty($GLOBALS['globax_enovathemes']['product-image-effect'])) ? $GLOBALS['globax_enovathemes']['product-image-effect'] : "overlay-none";
                $product_post_layout      = (isset($GLOBALS['globax_enovathemes']['product-post-layout']) && $GLOBALS['globax_enovathemes']['product-post-layout']) ? $GLOBALS['globax_enovathemes']['product-post-layout'] : "product-with-details";

                $thumb_size             = 'globax_384X384';
                $post_img_attr          = array();
                $post_img_sizes         = '100vw';
                $post_img_default_size  = $post_img_sizes;

                if ($product_post_layout == "grid") {
                    $thumb_size            = 'globax_588X588';
                    $post_img_default_size = '588px';
                    $post_img_sizes        = '(max-width: 319px) 92vw, (max-width: 479px) 384px, (max-width: 767px) 384px, (max-width: 1023px) 384px, (max-width: 1279px) 588px, '.$post_img_default_size;
                }

                $upsells = $product->get_upsell_ids();

            ?>

            <?php if ($upsells): ?>

                <?php

                    $product_ids = array();

                    foreach($upsells as $product_id => $value) {array_push($product_ids, $value);}

                    $args = array(
                        'post_type' => 'product',
                        'posts_per_page'      => 5000,
                        'ignore_sticky_posts' => 1,
                        'orderby'             => 'date',
                        'post__not_in'    => array($post->ID),
                        'post__in'        => $product_ids,
                    );

                    $upsells_products = new WP_Query($args);

                ?>

                <?php if ($upsells_products->have_posts()): ?>

                    <div class="related-products-wrapper upsells et-clearfix">
                        <h3 class="related-products-title stylish-dash"><?php echo esc_html__("Related products", 'globax'); ?></h3>
                        <div id="related-products" data-columns="3" class="related-products loop-product owl-carousel et-clearfix <?php echo esc_attr($product_image_effect); ?>">
                            <?php while($upsells_products->have_posts()) : $upsells_products->the_post(); ?>
                                <article class="product post et-clearfix" id="post-<?php $post->ID; ?>">
                                    <?php

                                        global $product;

                                        if (has_post_thumbnail()){

                                            if ( '' != the_title_attribute( 'echo=0' ) ){
                                                $post_img_attr['alt'] = the_title_attribute( 'echo=0' );
                                            }

                                            $post_img_original = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), "full" );
                                            $post_img_588      = get_the_post_thumbnail_url($post->ID,$thumb_size);

                                            $post_img_srcset = "";

                                            if (strpos($post_img_588, '588x')) {
                                                $post_img_srcset .= $post_img_588.' 588w';
                                            } else {
                                                $post_img_srcset .= $post_img_original[0].' '.$post_img_original[1].'w';
                                                $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                            }

                                            if (empty($post_img_srcset) || $product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                                $post_img_srcset = $post_img_original[0].' '.$post_img_original[1].'w';
                                                $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                                $thumb_size      = 'full';
                                            }

                                            $post_img_attr['srcset'] = $post_img_srcset;
                                            $post_img_attr['sizes']  = $post_img_sizes;
                                        }
                                    ?>
                                    <div class="post-inner et-item-inner et-clearfix">
                                        <?php if (defined('YITH_WCWL')): ?>
                                            <?php  echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                        <?php endif ?>
                                        <?php $stock_status = $product->get_stock_status(); ?>
                                        <?php if ($stock_status == "outofstock"): ?>
                                            <div class="product-status outofstock"><span><?php echo esc_html__( 'Out of stock', 'globax' ) ?></span></div>
                                        <?php else: ?>
                                            <?php if ( $product->is_on_sale() ) : ?>
                                                <div class="product-status onsale"><span><?php echo esc_html__( 'Sale!', 'globax' ) ?></span></div>
                                            <?php endif;?>
                                        <?php endif ?>
                                        <div class="post-image post-media overlay-hover">

                                            <?php if (class_exists('YITH_WCQV_Frontend')): ?>

                                                <?php if (get_option('yith-wcqv-enable') == 'yes'): ?>

                                                    <?php
                                                        global $product;
                                                        echo '<a href="#" class="button yith-wcqv-button product-single-button product-quick-view size-medium" data-product_id="' . $product->get_id() . '" title="'.esc_attr__("Product quick view", 'globax').'">' . esc_html__("Quick view", 'globax') . '</a>';
                                                    ?>
                                                <?php endif ?>
                                            <?php endif ?>

                                            <?php if ($product_image_effect != "overlay-none"): ?>
                                                <?php echo globax_enovathemes_product_image_overlay(get_the_ID()); ?>
                                                <div class="image-container visible">
                                                    <?php if (has_post_thumbnail()): ?>
                                                        <?php echo wp_get_attachment_image(get_post_thumbnail_id( get_the_ID() ), $thumb_size,false,$post_img_attr); ?>
                                                    <?php else: ?>
                                                        <?php echo wc_placeholder_img($thumb_size); ?>
                                                    <?php endif ?>
                                                </div>
                                            <?php else: ?>
                                                <a href="<?php the_permalink(); ?>" >
                                                    <div class="product-image-gallery">
                                                        <div class="image-container visible">
                                                            <div class="image-preloader"></div>
                                                            <?php if (has_post_thumbnail()): ?>
                                                                <?php echo wp_get_attachment_image(get_post_thumbnail_id( get_the_ID() ), $thumb_size,false,$post_img_attr); ?>
                                                            <?php else: ?>
                                                                <?php echo wc_placeholder_img($thumb_size); ?>
                                                            <?php endif ?>
                                                        </div>
                                                        <?php $product_gallery_ids = $product->get_gallery_image_ids(); ?>
                                                        <?php if (is_array($product_gallery_ids) && !empty($product_gallery_ids)): ?>
                                                            <?php foreach ($product_gallery_ids as $image_id): ?>
                                                                <?php

                                                                    $post_img_original = wp_get_attachment_image_src( $image_id, "full" );
                                                                    $post_img_282  = wp_get_attachment_image_src($image_id,'globax_282X282');
                                                                    $post_img_384  = wp_get_attachment_image_src($image_id,'globax_384X384');
                                                                    $post_img_588  = wp_get_attachment_image_src($image_id,'globax_588X588');
                                                                    $post_img_640  = wp_get_attachment_image_src($image_id,'globax_640X400');
                                                                    $post_img_960  = wp_get_attachment_image_src($image_id,'globax_960X600');

                                                                    $post_img_srcset = "";

                                                                    if (strpos($post_img_282[0], '282x')) {
                                                                        $post_img_srcset .= $post_img_282[0].' 282w';
                                                                    }

                                                                    if (strpos($post_img_384[0], '384x')) {
                                                                        $post_img_srcset .= ', '.$post_img_384[0].' 384w';
                                                                    }

                                                                    if (strpos($post_img_588[0], '588x')) {
                                                                        $post_img_srcset .= ', '.$post_img_588[0].' 588w';
                                                                    }

                                                                    if (strpos($post_img_640[0], '640x')) {

                                                                        $post_img_srcset .= ', '.$post_img_640[0].' 640w';
                                                                    }

                                                                    if (strpos($post_img_960[0], '960x')) {
                                                                        $post_img_srcset .= ', '.$post_img_960[0].' 960w';
                                                                    }

                                                                    if ($product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                                                        $thumb_size = 'full';
                                                                    }

                                                                    if (empty($post_img_srcset) || $product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                                                        $post_img_srcset = $post_img_original[0].' '.$post_img_original[1].'w';
                                                                        $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                                                    }

                                                                    $post_img_attr['srcset'] = $post_img_srcset;
                                                                    $post_img_attr['sizes']  = $post_img_sizes;
                                                                ?>
                                                                <?php echo wp_get_attachment_image($image_id,$thumb_size,false,$post_img_attr); ?>
                                                            <?php endforeach ?>
                                                        <?php endif ?>
                                                    </div>
                                                </a>
                                            <?php endif ?>
                                        </div>
                                        <div class="post-body et-clearfix">
                                            <div class="post-body-inner-wrap">
                                                <div class="post-body-inner">
                                                    <h4 class="post-title et-clearfix">
                                                        <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr__("Go to", 'globax').' '.the_title_attribute( 'echo=0' ); ?>"><?php the_title(); ?></a>
                                                        <!-- Rating -->
                                                        <?php 
                                                            if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) {
                                                                $rating = $product->get_average_rating();
                                                                $count  = 0;
                                                                $html = 0 < $rating ? '<span class="star-rating">' . wc_get_star_rating_html( $rating, $count ) . '</span>' : '';
                                                                echo apply_filters( 'woocommerce_product_get_rating_html', $html, $rating, $count );
                                                            }
                                                        ?>
                                                    </h4>
                                                    <?php if ( $price_html = $product->get_price_html() ) : ?>
                                                        <span class="price stylish-dash"><?php echo html_entity_decode($price_html); ?></span>
                                                    <?php endif; ?>
                                                    <!-- Add to cart -->
                                                    <?php
                                                        $product_type  = "simple";
                                                        if($product->is_type( 'variable' )) {
                                                            $product_type = "variable";
                                                        } elseif ($product->is_type( 'grouped' )) {
                                                            $product_type = "grouped";
                                                        } elseif ($product->is_type( 'external' )) {
                                                            $product_type = "external";
                                                        }
                                                        $product_class = 'button add_to_cart_button product-loop-button stylish-button';
                                                        if(get_option( 'woocommerce_enable_ajax_add_to_cart' ) === "yes" && $product_type == "simple" && $product->get_stock_status() != "outofstock"){
                                                            $product_class .=' ajax_add_to_cart';
                                                        }

                                                        echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                            sprintf( '<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" data-product_type="%s" data-product_status="%s" class="%s" title="%s" >%s</a>',
                                                                esc_url( $product->add_to_cart_url() ),
                                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                esc_attr( $product->get_id() ),
                                                                esc_attr( $product->get_sku() ),
                                                                esc_attr( $product_type ),
                                                                esc_attr( $product->get_stock_status() ),
                                                                esc_attr( $product_class ),
                                                                esc_html( $product->add_to_cart_text() ),
                                                                esc_html( $product->add_to_cart_text() )
                                                            ),
                                                        $product );
                                                    ?>
                                                    <?php
                                                        if(get_option( 'woocommerce_enable_ajax_add_to_cart' ) === "yes"){
                                                            echo '<div class="ajax-add-to-cart-loading"><div class="circle-loader"><div class="checkmark draw"></div></div></div>';
                                                        }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </article>
                            <?php endwhile; ?>
                            <?php wp_reset_postdata(); ?>
                        </div>
                    </div>

                <?php endif ?>
                
            <?php endif ?>

        <?php }

        remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
        add_action('woocommerce_cart_collaterals', 'globax_enovathemes_cross_sell_display',1);
        function globax_enovathemes_cross_sell_display (){ ?>

            <?php

                if ( is_checkout() ) {
                    return;
                }

                global $globax_enovathemes;

                $product_image_effect     = (isset($GLOBALS['globax_enovathemes']['product-image-effect']) && !empty($GLOBALS['globax_enovathemes']['product-image-effect'])) ? $GLOBALS['globax_enovathemes']['product-image-effect'] : "overlay-none";
                $product_post_layout      = (isset($GLOBALS['globax_enovathemes']['product-post-layout']) && $GLOBALS['globax_enovathemes']['product-post-layout']) ? $GLOBALS['globax_enovathemes']['product-post-layout'] : "product-with-details";

                $thumb_size             = 'globax_384X384';
                $post_img_attr          = array();
                $post_img_sizes         = '100vw';
                $post_img_default_size  = $post_img_sizes;

                if ($product_post_layout == "grid") {
                    $thumb_size            = 'globax_588X588';
                    $post_img_default_size = '588px';
                    $post_img_sizes        = '(max-width: 319px) 92vw, (max-width: 479px) 384px, (max-width: 767px) 384px, (max-width: 1023px) 384px, (max-width: 1279px) 588px, '.$post_img_default_size;
                }

                $cross_sells = array_filter( array_map( 'wc_get_product', WC()->cart->get_cross_sells() ), 'wc_products_array_filter_visible' );

            ?>

            <?php if ($cross_sells): ?>

                <div class="related-products-wrapper cross_sells et-clearfix">
                    <h3 class="related-products-title stylish-dash"><?php echo esc_html__("You may be interested in...", 'globax'); ?></h3>
                    <div id="related-products" data-columns="3" class="related-products loop-product owl-carousel et-clearfix <?php echo esc_attr($product_image_effect); ?>">
                    <?php foreach ( $cross_sells as $cross_sell ) : ?>
                        <?php $post_object = get_post( $cross_sell->get_id() ); ?>
                        <?php setup_postdata( $GLOBALS['post'] =& $post_object ); ?>
                        <?php global $product, $post; ?>
                        <article class="product post et-clearfix" id="post-<?php $post->ID; ?>">
                            <?php

                                global $product;

                                if (has_post_thumbnail()){

                                    if ( '' != the_title_attribute( 'echo=0' ) ){
                                        $post_img_attr['alt'] = the_title_attribute( 'echo=0' );
                                    }

                                    $post_img_original = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), "full" );
                                    $post_img_588      = get_the_post_thumbnail_url($post->ID,$thumb_size);

                                    $post_img_srcset = "";

                                    if (strpos($post_img_588, '588x')) {
                                        $post_img_srcset .= $post_img_588.' 588w';
                                    } else {
                                        $post_img_srcset .= $post_img_original[0].' '.$post_img_original[1].'w';
                                        $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                    }

                                    if (empty($post_img_srcset) || $product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                        $post_img_srcset = $post_img_original[0].' '.$post_img_original[1].'w';
                                        $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                        $thumb_size      = 'full';
                                    }

                                    $post_img_attr['srcset'] = $post_img_srcset;
                                    $post_img_attr['sizes']  = $post_img_sizes;
                                }
                            ?>
                            <div class="post-inner et-item-inner et-clearfix">
                                <?php if (defined('YITH_WCWL')): ?>
                                    <?php  echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                <?php endif ?>
                                <?php $stock_status = $product->get_stock_status(); ?>
                                <?php if ($stock_status == "outofstock"): ?>
                                    <div class="product-status outofstock"><span><?php echo esc_html__( 'Out of stock', 'globax' ) ?></span></div>
                                <?php else: ?>
                                    <?php if ( $product->is_on_sale() ) : ?>
                                        <div class="product-status onsale"><span><?php echo esc_html__( 'Sale!', 'globax' ) ?></span></div>
                                    <?php endif;?>
                                <?php endif ?>
                                <div class="post-image post-media overlay-hover">

                                    <?php if (class_exists('YITH_WCQV_Frontend')): ?>

                                        <?php if (get_option('yith-wcqv-enable') == 'yes'): ?>

                                            <?php
                                                global $product;
                                                echo '<a href="#" class="button yith-wcqv-button product-single-button product-quick-view size-medium" data-product_id="' . $product->get_id() . '" title="'.esc_attr__("Product quick view", 'globax').'">' . esc_html__("Quick view", 'globax') . '</a>';
                                            ?>
                                        <?php endif ?>
                                    <?php endif ?>

                                    <?php if ($product_image_effect != "overlay-none"): ?>
                                        <?php echo globax_enovathemes_product_image_overlay(get_the_ID()); ?>
                                        <div class="image-container visible">
                                            <?php if (has_post_thumbnail()): ?>
                                                <?php echo wp_get_attachment_image(get_post_thumbnail_id( get_the_ID() ), $thumb_size,false,$post_img_attr); ?>
                                            <?php else: ?>
                                                <?php echo wc_placeholder_img($thumb_size); ?>
                                            <?php endif ?>
                                        </div>
                                    <?php else: ?>
                                        <a href="<?php the_permalink(); ?>" >
                                            <div class="product-image-gallery">
                                                <div class="image-container visible">
                                                    <div class="image-preloader"></div>
                                                    <?php if (has_post_thumbnail()): ?>
                                                        <?php echo wp_get_attachment_image(get_post_thumbnail_id( get_the_ID() ), $thumb_size,false,$post_img_attr); ?>
                                                    <?php else: ?>
                                                        <?php echo wc_placeholder_img($thumb_size); ?>
                                                    <?php endif ?>
                                                </div>
                                                <?php $product_gallery_ids = $product->get_gallery_image_ids(); ?>
                                                <?php if (is_array($product_gallery_ids) && !empty($product_gallery_ids)): ?>
                                                    <?php foreach ($product_gallery_ids as $image_id): ?>
                                                        <?php

                                                            $post_img_original = wp_get_attachment_image_src( $image_id, "full" );
                                                            $post_img_282  = wp_get_attachment_image_src($image_id,'globax_282X282');
                                                            $post_img_384  = wp_get_attachment_image_src($image_id,'globax_384X384');
                                                            $post_img_588  = wp_get_attachment_image_src($image_id,'globax_588X588');
                                                            $post_img_640  = wp_get_attachment_image_src($image_id,'globax_640X400');
                                                            $post_img_960  = wp_get_attachment_image_src($image_id,'globax_960X600');

                                                            $post_img_srcset = "";

                                                            if (strpos($post_img_282[0], '282x')) {
                                                                $post_img_srcset .= $post_img_282[0].' 282w';
                                                            }

                                                            if (strpos($post_img_384[0], '384x')) {
                                                                $post_img_srcset .= ', '.$post_img_384[0].' 384w';
                                                            }

                                                            if (strpos($post_img_588[0], '588x')) {
                                                                $post_img_srcset .= ', '.$post_img_588[0].' 588w';
                                                            }

                                                            if (strpos($post_img_640[0], '640x')) {

                                                                $post_img_srcset .= ', '.$post_img_640[0].' 640w';
                                                            }

                                                            if (strpos($post_img_960[0], '960x')) {
                                                                $post_img_srcset .= ', '.$post_img_960[0].' 960w';
                                                            }

                                                            if ($product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                                                $thumb_size = 'full';
                                                            }

                                                            if (empty($post_img_srcset) || $product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                                                $post_img_srcset = $post_img_original[0].' '.$post_img_original[1].'w';
                                                                $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                                            }

                                                            $post_img_attr['srcset'] = $post_img_srcset;
                                                            $post_img_attr['sizes']  = $post_img_sizes;
                                                        ?>
                                                        <?php echo wp_get_attachment_image($image_id,$thumb_size,false,$post_img_attr); ?>
                                                    <?php endforeach ?>
                                                <?php endif ?>
                                            </div>
                                        </a>
                                    <?php endif ?>
                                </div>
                                <div class="post-body et-clearfix">
                                    <div class="post-body-inner-wrap">
                                        <div class="post-body-inner">
                                                    <h4 class="post-title et-clearfix">
                                                        <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr__("Go to", 'globax').' '.the_title_attribute( 'echo=0' ); ?>"><?php the_title(); ?></a>
                                                        <!-- Rating -->
                                                        <?php 
                                                            if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) {
                                                                $rating = $product->get_average_rating();
                                                                $count  = 0;
                                                                $html = 0 < $rating ? '<span class="star-rating">' . wc_get_star_rating_html( $rating, $count ) . '</span>' : '';
                                                                echo apply_filters( 'woocommerce_product_get_rating_html', $html, $rating, $count );
                                                            }
                                                        ?>
                                                    </h4>
                                                    <?php if ( $price_html = $product->get_price_html() ) : ?>
                                                        <span class="price stylish-dash"><?php echo html_entity_decode($price_html); ?></span>
                                                    <?php endif; ?>
                                                    <!-- Add to cart -->
                                                    <?php
                                                        $product_type  = "simple";
                                                        if($product->is_type( 'variable' )) {
                                                            $product_type = "variable";
                                                        } elseif ($product->is_type( 'grouped' )) {
                                                            $product_type = "grouped";
                                                        } elseif ($product->is_type( 'external' )) {
                                                            $product_type = "external";
                                                        }
                                                        $product_class = 'button add_to_cart_button product-loop-button stylish-button';
                                                        if(get_option( 'woocommerce_enable_ajax_add_to_cart' ) === "yes" && $product_type == "simple" && $product->get_stock_status() != "outofstock"){
                                                            $product_class .=' ajax_add_to_cart';
                                                        }

                                                        echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                            sprintf( '<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" data-product_type="%s" data-product_status="%s" class="%s" title="%s" >%s</a>',
                                                                esc_url( $product->add_to_cart_url() ),
                                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                esc_attr( $product->get_id() ),
                                                                esc_attr( $product->get_sku() ),
                                                                esc_attr( $product_type ),
                                                                esc_attr( $product->get_stock_status() ),
                                                                esc_attr( $product_class ),
                                                                esc_html( $product->add_to_cart_text() ),
                                                                esc_html( $product->add_to_cart_text() )
                                                            ),
                                                        $product );
                                                    ?>
                                                    <?php
                                                        if(get_option( 'woocommerce_enable_ajax_add_to_cart' ) === "yes"){
                                                            echo '<div class="ajax-add-to-cart-loading"><div class="circle-loader"><div class="checkmark draw"></div></div></div>';
                                                        }
                                                    ?>
                                                </div>
                                    </div>
                                </div>
                            </div>
                        </article>
                    <?php endforeach; ?>
                    </div>
                </div>
                
            <?php endif; ?>

        <?php }

        remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
        add_action('woocommerce_after_single_product_summary', 'globax_enovathemes_output_related_products', 20 );
        function globax_enovathemes_output_related_products (){ ?>

            <?php

                global $post, $globax_enovathemes;

                $product_image_effect     = (isset($GLOBALS['globax_enovathemes']['product-image-effect']) && !empty($GLOBALS['globax_enovathemes']['product-image-effect'])) ? $GLOBALS['globax_enovathemes']['product-image-effect'] : "overlay-none";
                $product_post_layout      = (isset($GLOBALS['globax_enovathemes']['product-post-layout']) && $GLOBALS['globax_enovathemes']['product-post-layout']) ? $GLOBALS['globax_enovathemes']['product-post-layout'] : "product-with-details";

                $thumb_size             = 'globax_384X384';
                $post_img_attr          = array();
                $post_img_sizes         = '100vw';
                $post_img_default_size  = $post_img_sizes;

                if ($product_post_layout == "grid") {
                    $thumb_size            = 'globax_588X588';
                    $post_img_default_size = '588px';
                    $post_img_sizes        = '(max-width: 319px) 92vw, (max-width: 479px) 384px, (max-width: 767px) 384px, (max-width: 1023px) 384px, (max-width: 1279px) 588px, '.$post_img_default_size;
                }

                $terms = get_the_terms( $post->ID , 'product_cat');

            ?>

            <?php if ($terms): ?>

                <?php

                    $categoryids = array();
                    foreach($terms as $category) {$categoryids[] = $category->term_id;}

                    $args = array(
                        'post_type' => 'product',
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'product_cat',
                                'field'    => 'id',
                                'terms'    => $categoryids,
                                'operator' => 'IN'
                             )
                        ),
                        'posts_per_page'      => 5000,
                        'ignore_sticky_posts' => 1,
                        'orderby'             => 'date',
                        'post__not_in'        => array($post->ID)
                    );

                    $related_products = new WP_Query($args);

                ?>

                <?php if ($related_products->have_posts()): ?>

                    <div class="related-products-wrapper et-clearfix">
                        <h3 class="related-products-title stylish-dash"><?php echo esc_html__("Related products", 'globax'); ?></h3>
                        <div id="related-products" data-columns="3" class="related-products loop-product owl-carousel et-clearfix <?php echo esc_attr($product_image_effect); ?>">
                            <?php while($related_products->have_posts()) : $related_products->the_post(); ?>
                                <article class="product post et-clearfix" id="post-<?php $post->ID; ?>">
                                    <?php

                                        global $product;

                                        if (has_post_thumbnail()){

                                            if ( '' != the_title_attribute( 'echo=0' ) ){
                                                $post_img_attr['alt'] = the_title_attribute( 'echo=0' );
                                            }

                                            $post_img_original = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), "full" );
                                            $post_img_588      = get_the_post_thumbnail_url($post->ID,$thumb_size);

                                            $post_img_srcset = "";

                                            if (strpos($post_img_588, '588x')) {
                                                $post_img_srcset .= $post_img_588.' 588w';
                                            } else {
                                                $post_img_srcset .= $post_img_original[0].' '.$post_img_original[1].'w';
                                                $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                            }

                                            if (empty($post_img_srcset) || $product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                                $post_img_srcset = $post_img_original[0].' '.$post_img_original[1].'w';
                                                $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                                $thumb_size      = 'full';
                                            }

                                            $post_img_attr['srcset'] = $post_img_srcset;
                                            $post_img_attr['sizes']  = $post_img_sizes;
                                        }
                                    ?>
                                    <div class="post-inner et-item-inner et-clearfix">
                                        <?php if (defined('YITH_WCWL')): ?>
                                            <?php  echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                        <?php endif ?>
                                        <?php $stock_status = $product->get_stock_status(); ?>
                                        <?php if ($stock_status == "outofstock"): ?>
                                            <div class="product-status outofstock"><span><?php echo esc_html__( 'Out of stock', 'globax' ) ?></span></div>
                                        <?php else: ?>
                                            <?php if ( $product->is_on_sale() ) : ?>
                                                <div class="product-status onsale"><span><?php echo esc_html__( 'Sale!', 'globax' ) ?></span></div>
                                            <?php endif;?>
                                        <?php endif ?>
                                        <div class="post-image post-media overlay-hover">

                                            <?php if (class_exists('YITH_WCQV_Frontend')): ?>

                                                <?php if (get_option('yith-wcqv-enable') == 'yes'): ?>

                                                    <?php
                                                        global $product;
                                                        echo '<a href="#" class="button yith-wcqv-button product-single-button product-quick-view size-medium" data-product_id="' . $product->get_id() . '" title="'.esc_attr__("Product quick view", 'globax').'">' . esc_html__("Quick view", 'globax') . '</a>';
                                                    ?>
                                                <?php endif ?>
                                            <?php endif ?>

                                            <?php if ($product_image_effect != "overlay-none"): ?>
                                                <?php echo globax_enovathemes_product_image_overlay(get_the_ID()); ?>
                                                <div class="image-container visible">
                                                    <?php if (has_post_thumbnail()): ?>
                                                        <?php echo wp_get_attachment_image(get_post_thumbnail_id( get_the_ID() ), $thumb_size,false,$post_img_attr); ?>
                                                    <?php else: ?>
                                                        <?php echo wc_placeholder_img($thumb_size); ?>
                                                    <?php endif ?>
                                                </div>
                                            <?php else: ?>
                                                <a href="<?php the_permalink(); ?>" >
                                                    <div class="product-image-gallery">
                                                        <div class="image-container visible">
                                                            <div class="image-preloader"></div>
                                                            <?php if (has_post_thumbnail()): ?>
                                                                <?php echo wp_get_attachment_image(get_post_thumbnail_id( get_the_ID() ), $thumb_size,false,$post_img_attr); ?>
                                                            <?php else: ?>
                                                                <?php echo wc_placeholder_img($thumb_size); ?>
                                                            <?php endif ?>
                                                        </div>
                                                        <?php $product_gallery_ids = $product->get_gallery_image_ids(); ?>
                                                        <?php if (is_array($product_gallery_ids) && !empty($product_gallery_ids)): ?>
                                                            <?php foreach ($product_gallery_ids as $image_id): ?>
                                                                <?php

                                                                    $post_img_original = wp_get_attachment_image_src( $image_id, "full" );
                                                                    $post_img_282  = wp_get_attachment_image_src($image_id,'globax_282X282');
                                                                    $post_img_384  = wp_get_attachment_image_src($image_id,'globax_384X384');
                                                                    $post_img_588  = wp_get_attachment_image_src($image_id,'globax_588X588');
                                                                    $post_img_640  = wp_get_attachment_image_src($image_id,'globax_640X400');
                                                                    $post_img_960  = wp_get_attachment_image_src($image_id,'globax_960X600');

                                                                    $post_img_srcset = "";

                                                                    if (strpos($post_img_282[0], '282x')) {
                                                                        $post_img_srcset .= $post_img_282[0].' 282w';
                                                                    }

                                                                    if (strpos($post_img_384[0], '384x')) {
                                                                        $post_img_srcset .= ', '.$post_img_384[0].' 384w';
                                                                    }

                                                                    if (strpos($post_img_588[0], '588x')) {
                                                                        $post_img_srcset .= ', '.$post_img_588[0].' 588w';
                                                                    }

                                                                    if (strpos($post_img_640[0], '640x')) {

                                                                        $post_img_srcset .= ', '.$post_img_640[0].' 640w';
                                                                    }

                                                                    if (strpos($post_img_960[0], '960x')) {
                                                                        $post_img_srcset .= ', '.$post_img_960[0].' 960w';
                                                                    }

                                                                    if ($product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                                                        $thumb_size = 'full';
                                                                    }

                                                                    if (empty($post_img_srcset) || $product_post_layout == "masonry1" || $product_post_layout == "masonry2") {
                                                                        $post_img_srcset = $post_img_original[0].' '.$post_img_original[1].'w';
                                                                        $post_img_sizes  = '(max-width: 479px) 92vw, '.$post_img_original[1].'px';
                                                                    }

                                                                    $post_img_attr['srcset'] = $post_img_srcset;
                                                                    $post_img_attr['sizes']  = $post_img_sizes;
                                                                ?>
                                                                <?php echo wp_get_attachment_image($image_id,$thumb_size,false,$post_img_attr); ?>
                                                            <?php endforeach ?>
                                                        <?php endif ?>
                                                    </div>
                                                </a>
                                            <?php endif ?>
                                        </div>
                                        <div class="post-body et-clearfix">
                                            <div class="post-body-inner-wrap">
                                                <div class="post-body-inner">
                                                    <h4 class="post-title et-clearfix">
                                                        <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr__("Go to", 'globax').' '.the_title_attribute( 'echo=0' ); ?>"><?php the_title(); ?></a>
                                                        <!-- Rating -->
                                                        <?php 
                                                            if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) {
                                                                $rating = $product->get_average_rating();
                                                                $count  = 0;
                                                                $html = 0 < $rating ? '<span class="star-rating">' . wc_get_star_rating_html( $rating, $count ) . '</span>' : '';
                                                                echo apply_filters( 'woocommerce_product_get_rating_html', $html, $rating, $count );
                                                            }
                                                        ?>
                                                    </h4>
                                                    <?php if ( $price_html = $product->get_price_html() ) : ?>
                                                        <span class="price stylish-dash"><?php echo html_entity_decode($price_html); ?></span>
                                                    <?php endif; ?>
                                                    <!-- Add to cart -->
                                                    <?php
                                                        $product_type  = "simple";
                                                        if($product->is_type( 'variable' )) {
                                                            $product_type = "variable";
                                                        } elseif ($product->is_type( 'grouped' )) {
                                                            $product_type = "grouped";
                                                        } elseif ($product->is_type( 'external' )) {
                                                            $product_type = "external";
                                                        }
                                                        $product_class = 'button add_to_cart_button product-loop-button stylish-button';
                                                        if(get_option( 'woocommerce_enable_ajax_add_to_cart' ) === "yes" && $product_type == "simple" && $product->get_stock_status() != "outofstock"){
                                                            $product_class .=' ajax_add_to_cart';
                                                        }

                                                        echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                            sprintf( '<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" data-product_type="%s" data-product_status="%s" class="%s" title="%s" >%s</a>',
                                                                esc_url( $product->add_to_cart_url() ),
                                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                esc_attr( $product->get_id() ),
                                                                esc_attr( $product->get_sku() ),
                                                                esc_attr( $product_type ),
                                                                esc_attr( $product->get_stock_status() ),
                                                                esc_attr( $product_class ),
                                                                esc_html( $product->add_to_cart_text() ),
                                                                esc_html( $product->add_to_cart_text() )
                                                            ),
                                                        $product );
                                                    ?>
                                                    <?php
                                                        if(get_option( 'woocommerce_enable_ajax_add_to_cart' ) === "yes"){
                                                            echo '<div class="ajax-add-to-cart-loading"><div class="circle-loader"><div class="checkmark draw"></div></div></div>';
                                                        }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </article>
                            <?php endwhile; ?>
                            <?php wp_reset_postdata(); ?>
                        </div>
                    </div>

                <?php endif ?>
                
            <?php endif ?>

        <?php }

        remove_action( 'woocommerce_review_before', 'woocommerce_review_display_gravatar', 10 );
        add_action( 'woocommerce_review_before', 'globax_enovathemes_woocommerce_review_display_gravatar', 10 );
        function globax_enovathemes_woocommerce_review_display_gravatar( $comment ) {
            echo get_avatar( $comment, apply_filters( 'woocommerce_review_gravatar_size', '72' ), '' );
        }

        if (class_exists('YITH_WCQV')) {
            remove_action( 'yith_wcqv_product_image', 'woocommerce_show_product_sale_flash', 10 );
            remove_action( 'yith_wcqv_product_image', 'woocommerce_show_product_images', 20 );
            add_action( 'yith_wcqv_product_image', 'globax_enovathemes_woocommerce_show_product_images', 20 );
            function globax_enovathemes_woocommerce_show_product_images(){?>
                <div class="woocommerce-product-gallery et-clearfix">
                    <div class="woocommerce-product-gallery-inner et-clearfix">
                        <?php

                            global $product,$post,$globax_enovathemes;

                            $product_single_post_layout = (isset($GLOBALS['globax_enovathemes']['product-single-post-layout']) && !empty($GLOBALS['globax_enovathemes']['product-single-post-layout'])) ? $GLOBALS['globax_enovathemes']['product-single-post-layout'] : "single-product-tabs-under";
                            $product_image_original     = (isset($GLOBALS['globax_enovathemes']['product-image-original']) && $GLOBALS['globax_enovathemes']['product-image-original'] == 1) ? "true" : "false";

                            $post_img_attr          = array();
                            $attachment_ids         = $product->get_gallery_image_ids();
                            $shop_single_image_size = apply_filters( 'single_product_large_thumbnail_size', 'shop_single' );
                            $thumb_size             = (!empty($shop_single_image_size)) ? $shop_single_image_size : 'full';
                            $product_gallery_thumb  = 'globax_144X144';
                        
                            if ($product_single_post_layout == 'single-product-tabs-inside') {
                                $product_gallery_thumb = 'globax_60X90';
                            }

                            $product_gallery_attr = 'class="product-image-zoom" data-lightbox-gallery="product-single"';

                            if ($product_image_original == "true") {
                                $shop_single_image_size = "full";
                                $thumb_size             = "full";
                            }

                        ?>
                        <?php
                            if (defined('YITH_WCWL')){
                                echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                            }
                        ?>
                        <?php $stock_status = $product->get_stock_status(); ?>
                        <?php if ($stock_status == "outofstock"): ?>
                            <div class="product-status outofstock"><span><?php echo esc_html__( 'Out of stock', 'globax' ) ?></span></div>
                        <?php else: ?>
                            <?php if ( $product->is_on_sale() ) : ?>
                                <div class="product-status onsale"><span><?php echo esc_html__( 'Sale!', 'globax' ) ?></span></div>
                            <?php endif;?>
                        <?php endif ?>
                        <?php if (!empty($attachment_ids)): ?>
                            <div id="product-gallery" class="product-gallery post-media product-gallery-<?php echo esc_attr($post->ID); ?>">
                                <ul id="product-gallery-set" class="slides et-clearfix carousel_thumb">
                                    
                                    <?php
                                        $post_featured_img                = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), $thumb_size);
                                        $post_featured_img_original       = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                                        $post_featured_img_sizes          = '(max-width: 479px) 92vw, (max-width: 1023px) '.$post_featured_img_original[1].'px, '.$post_featured_img[1].'px';
                                        $post_featured_img_srcset         = $post_featured_img_original[0].' '.$post_featured_img_original[1].'w';
                                        $post_featured_img_srcset         .= ', '.$post_featured_img[0].' '.$post_featured_img[1].'w';
                                        $post_featured_img_attr['srcset'] = $post_featured_img_srcset;
                                        $post_featured_img_attr['sizes']  = $post_featured_img_sizes;
                                        $post_featured_img_attr['alt']    = esc_html(get_the_title($post->ID));

                                        if ($product_image_original == "true") {
                                            $product_gallery_attr = 'class="product-image-zoom photoswip-product" data-size="'.$post_featured_img_original[1].'x'.$post_featured_img_original[2].'"';
                                        }
                                    ?>
                                    <?php if ($post_featured_img[0]): ?>
                                        <li class="product-featured-img">
                                            <div>
                                                <a href="<?php echo esc_attr($post_featured_img_original[0]); ?>" <?php echo html_entity_decode($product_gallery_attr); ?>>
                                                    <?php echo wp_get_attachment_image( get_post_thumbnail_id($post->ID), $thumb_size,false,$post_featured_img_attr); ?>
                                                </a>
                                            </div>
                                        </li>
                                    <?php endif ?>
                                    <?php foreach ( $attachment_ids as $attachment_id ) { ?>
                                        <li>
                                            <?php
                                                $post_img                = wp_get_attachment_image_src($attachment_id, $thumb_size);
                                                $post_img_original       = wp_get_attachment_image_src($attachment_id, 'full');
                                                $post_img_sizes          = '(max-width: 479px) 92vw, (max-width: 1023px) '.$post_img_original[1].'px, '.$post_img[1].'px';
                                                $post_img_srcset         = $post_img_original[0].' '.$post_img_original[1].'w';
                                                $post_img_srcset         .= ', '.$post_img[0].' '.$post_img[1].'w';
                                                $post_img_attr['srcset'] = $post_img_srcset;
                                                $post_img_attr['sizes']  = $post_img_sizes;
                                                $post_img_attr['alt']    = esc_html(get_the_title($post->ID));

                                                if ($product_image_original == "true") {
                                                    $product_gallery_attr = 'class="product-image-zoom photoswip-product" data-size="'.$post_img_original[1].'x'.$post_img_original[2].'"';
                                                }
                                            ?>
                                            <div class="image-container">
                                                <a href="<?php echo esc_url($post_img_original[0]); ?>" <?php echo html_entity_decode($product_gallery_attr); ?>>
                                                    <?php echo wp_get_attachment_image( $attachment_id, $thumb_size,false,$post_img_attr); ?>
                                                </a>
                                            </div>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        <?php else: ?>
                            <?php
                                $post_img                = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), $thumb_size);
                                $post_img_original       = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                                $post_img_sizes          = '(max-width: 479px) 92vw, (max-width: 1023px) '.$post_img_original[1].'px, '.$post_img[1].'px';
                                $post_img_srcset         = $post_img_original[0].' '.$post_img_original[1].'w';
                                $post_img_srcset         .= ', '.$post_img[0].' '.$post_img[1].'w';
                                $post_img_attr['srcset'] = $post_img_srcset;
                                $post_img_attr['sizes']  = $post_img_sizes;
                                $post_img_attr['alt']    = esc_html(get_the_title($post->ID));
                            ?>
                            <?php if ($post_img[0]): ?>
                                <div id="product-gallery" class="product-gallery post-media">
                                    <a href="<?php echo esc_attr($post_img_original[0]); ?>" <?php echo html_entity_decode($product_gallery_attr); ?>>
                                        <?php echo wp_get_attachment_image(get_post_thumbnail_id($post->ID), $thumb_size,false,$post_img_attr); ?>
                                    </a>
                                </div>
                            <?php else: ?>
                                <?php echo wc_placeholder_img($thumb_size); ?>  
                            <?php endif ?>
                        <?php endif ?>
                    </div>
                </div>
            <?php }

            remove_action( 'yith_wcqv_product_summary', 'woocommerce_template_single_price', 15 );
            add_action( 'yith_wcqv_product_summary', 'woocommerce_template_single_price', 2 );
        }
        
    }

/* Scripts
---------------*/

    function globax_enovathemes_script()
    {
        if(!is_admin())
        {
            global $globax_enovathemes,$wp_query;

            $custom_scroll                    = (isset($GLOBALS['globax_enovathemes']['custom-scroll']) && $GLOBALS['globax_enovathemes']['custom-scroll'] == 1) ? "true" : "false";
            $custom_scroll_cursorcolor        = (isset($GLOBALS['globax_enovathemes']['custom-scroll-cursorcolor']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-cursorcolor'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-cursorcolor'] : '#222222';
            $custom_scroll_railcolor          = (isset($GLOBALS['globax_enovathemes']['custom-scroll-railcolor']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-railcolor'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-railcolor'] : '#666666'; 
            $custom_scroll_cursoropacitymin   = (isset($GLOBALS['globax_enovathemes']['custom-scroll-cursoropacitymin']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-cursoropacitymin'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-cursoropacitymin'] : '100';
            $custom_scroll_cursoropacitymax   = (isset($GLOBALS['globax_enovathemes']['custom-scroll-cursoropacitymax']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-cursoropacitymax'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-cursoropacitymax'] : '100';
            $custom_scroll_cursorwidth        = (isset($GLOBALS['globax_enovathemes']['custom-scroll-cursorwidth']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-cursorwidth'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-cursorwidth'] : '10';
            $custom_scroll_cursorborderradius = (isset($GLOBALS['globax_enovathemes']['custom-scroll-cursorborderradius']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-cursorborderradius'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-cursorborderradius'] : '5';
            $custom_scroll_scrollspeed        = (isset($GLOBALS['globax_enovathemes']['custom-scroll-scrollspeed']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-scrollspeed'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-scrollspeed'] : '60';
            $custom_scroll_mousescrollstep    = (isset($GLOBALS['globax_enovathemes']['custom-scroll-mousescrollstep']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-mousescrollstep'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-mousescrollstep'] : '40';
            $custom_scroll_mousescrollstep    = (isset($GLOBALS['globax_enovathemes']['custom-scroll-mousescrollstep']) && !empty($GLOBALS['globax_enovathemes']['custom-scroll-mousescrollstep'])) ? $GLOBALS['globax_enovathemes']['custom-scroll-mousescrollstep'] : '40';

            $sticky_header_height = (isset($GLOBALS['globax_enovathemes']['sticky-header-height']) && $GLOBALS['globax_enovathemes']['sticky-header-height']) ? $GLOBALS['globax_enovathemes']['sticky-header-height'] : "90";

            $post_max   = $wp_query->max_num_pages;
            $post_paged = (get_query_var('page')) ? get_query_var('page') : 1;
            
            $project_max      = (empty($project_per_page)) ? $wp_query->max_num_pages : ceil($wp_query->found_posts/$project_per_page);
            $project_per_page = (isset($GLOBALS['globax_enovathemes']['project-per-page']) && !empty($GLOBALS['globax_enovathemes']['project-per-page'])) ? $GLOBALS['globax_enovathemes']['project-per-page'] : get_option( 'posts_per_page' );

            $product_max      = (empty($product_per_page)) ? $wp_query->max_num_pages : ceil($wp_query->found_posts/$product_per_page);
            $product_per_page = (isset($GLOBALS['globax_enovathemes']['product-per-page']) && !empty($GLOBALS['globax_enovathemes']['product-per-page'])) ? $GLOBALS['globax_enovathemes']['product-per-page'] : get_option( 'posts_per_page' );


            // Woocommerce single product button
            $product_single_button_class = 'product-single-button';

            wp_enqueue_style( 'globax-style', get_stylesheet_uri() );
            wp_enqueue_style( 'globax-default-fonts', globax_enovathemes_fonts_url(), array(), '1.0.0' );

            if (isset($GLOBALS['globax_enovathemes']['disable-defaults']) && $GLOBALS['globax_enovathemes']['disable-defaults'] == 1) {
                wp_dequeue_style( 'globax-fonts' );
            }

            if ( is_singular() && get_option( 'thread_comments' ) ) {
                wp_enqueue_script( 'comment-reply' );
            }

            if (isset($GLOBALS['globax_enovathemes']['google-map-api']) && !empty($GLOBALS['globax_enovathemes']['google-map-api'])) {
                wp_enqueue_script( 'gmap', '//maps.google.com/maps/api/js?key='.esc_attr($GLOBALS['globax_enovathemes']['google-map-api']), array(), false);
            } else {
                wp_enqueue_script( 'gmap', '//maps.google.com/maps/api/js', array(), false);
            }
            wp_enqueue_script( 'modernizr', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/modernizr.js', array(), false);
            if (isset($GLOBALS['globax_enovathemes']['smooth-scroll']) && $GLOBALS['globax_enovathemes']['smooth-scroll'] == 1) {
                wp_enqueue_script( 'smoothpagescroll', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/smoothPageScroll.min.js', array('jquery'), '', true);
            }

            wp_enqueue_script( 'imagesloaded');
            wp_enqueue_script( 'jquery-masonry');
            wp_enqueue_script( 'hoverIntent');


            if (isset($GLOBALS['globax_enovathemes']['combine-scripts']) && $GLOBALS['globax_enovathemes']['combine-scripts'] == 1) {
                wp_enqueue_script( 'controller', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/controller-combined.js', array('jquery'), '', true);
            } else {
                wp_enqueue_script( 'waypoint', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/waypoint.js', array('jquery'), '', true);
                wp_enqueue_script( 'nice-scroll', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/nice-scroll.js', array('jquery'), '', true);
                wp_enqueue_script( 'classie', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/classie.js', array('jquery'), '', true);
                wp_enqueue_script( 'inview', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/inview.js', array('jquery'), '', true);
                wp_enqueue_script( 'easing', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/easing.js', array('jquery'), '', true);
                wp_enqueue_script( 'mobile-events', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/mobile-events.js', array('jquery'), '', true);
                wp_enqueue_script( 'easy-pie-chart', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/easy-pie-chart.js', array('jquery'), '', true);
                wp_enqueue_script( 'animate-colors', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/animate-colors.js', array('jquery'), '', true);
                wp_enqueue_script( 'flex-slider', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/flex-slider.js', array('jquery'), '', true);
                wp_enqueue_script( 'mousewheel', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/mousewheel.js', array('jquery'), '', true);
                wp_enqueue_script( 'from-to', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/from-to.js', array('jquery'), '', true);
                wp_enqueue_script( 'count-down', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/count-down.js', array('jquery'), '', true);
                wp_enqueue_script( 'tooltip', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/tooltip.js', array('jquery'), '', true);
                wp_enqueue_script( 'overlay-fluid', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/overlay-fluid.js', array('jquery'), '', true);
                wp_enqueue_script( 'nivolightbox', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/nivolightbox.js', array('jquery'), '', true);
                wp_enqueue_script( 'slick-carousel', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/slick-carousel.js', array('jquery'), '', true);
                wp_enqueue_script( 'footer-sticky', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/footer-sticky.js', array('jquery'), '', true);
                wp_enqueue_script( 'zoom-in', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/zoom-in.js', array('jquery'), '', true);
                wp_enqueue_script( 'cookie', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/cookie.js', array('jquery'), '', true);
                wp_enqueue_script( 'typeit', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/typeit.js', array('jquery'), '', true);
                wp_enqueue_script( 'sticky-kit', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/sticky-kit.js', array('jquery'), '', true);
                wp_enqueue_script( 'owl-carousel', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/owl-carousel.js', array('jquery'), '', true);
                wp_enqueue_script( 'isotop', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/isotop.js', array('jquery'), '', true);
                wp_enqueue_script( 'photoswip', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/photoswip.js', array('jquery'), '', true);
                wp_enqueue_script( 'anime', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/anime.min.js', array(), '', true);
                wp_enqueue_script( 'controller', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/controller.js', array('jquery'), '', true);
            }

            wp_localize_script( 
                'controller', 
                'controller_opt', 
                array(
                    'customScroll'                   => $custom_scroll, 
                    'customScrollCursorcolor'        => $custom_scroll_cursorcolor,
                    'customScrollRailcolor'          => $custom_scroll_railcolor,
                    'customScrollCursorOpacityMin'   => $custom_scroll_cursoropacitymin,
                    'customScrollCursorOpacityMax'   => $custom_scroll_cursoropacitymax,
                    'customScrollCursorWidth'        => $custom_scroll_cursorwidth,
                    'customScrollCursorBorderRadius' => $custom_scroll_cursorborderradius,
                    'customScrollScrollSpeed'        => $custom_scroll_scrollspeed,
                    'customScrollMouseScrollStep'    => $custom_scroll_mousescrollstep,
                    'postMax'                        => $post_max,
                    'postStartPage'                  => $post_paged,
                    'postNextLink'                   => next_posts($post_max, false),
                    'postNoText'                     => esc_html__("No more posts", 'globax'),
                    'stickyHeaderHeight'             => $sticky_header_height,
                    'projectMax'                     => $project_max,
                    'projectNextLink'                => next_posts($project_max, false),
                    'projectNoText'                  => esc_html__("No more projects", 'globax'),
                    'projectLoadingText'             => esc_html__("Loading projects", 'globax'),
                    'productMax'                     => $product_max,
                    'productNextLink'                => next_posts($product_max, false),
                    'productNoText'                  => esc_html__("No more products", 'globax'),
                    'productLoadingText'             => esc_html__("Loading products", 'globax'),
                    'productButtonClass'             => $product_single_button_class,
                    'ajaxurl'                        => admin_url( 'admin-ajax.php', 'relative' ),
                )
            );

            if (is_page()) {

                $values          = get_post_custom( get_the_ID() );
                $one_page        = (isset($values["one_page"][0]) && $values["one_page"][0] == "true") ? "true" : "false";

                if ($one_page == "true") {
                   
                    $one_page_speed  = ($GLOBALS['globax_enovathemes']['one-page-speed']) ? esc_js($GLOBALS['globax_enovathemes']['one-page-speed']) : 750;
                    $one_page_hash   = ($GLOBALS['globax_enovathemes']['one-page-hash'] && $GLOBALS['globax_enovathemes']['one-page-hash'] == 1) ? 'true' : 'false';
                    $one_page_nav    = ($GLOBALS['globax_enovathemes']['one-page-navigation']) ? $GLOBALS['globax_enovathemes']['one-page-navigation'] : 'side';
                    $one_page_filter = (isset($GLOBALS['globax_enovathemes']['one-page-filter']) && $GLOBALS['globax_enovathemes']['one-page-filter']) ? explode(',',esc_attr($GLOBALS['globax_enovathemes']['one-page-filter'])) : '';
                    $et_filter_array    = array();

                    $offset = 0;
                    $from   = 0;

                    $sidebar_navigation    = (isset($GLOBALS['globax_enovathemes']['sidebar-navigation']) && $GLOBALS['globax_enovathemes']['sidebar-navigation'] == 1) ? "true" : "false";
                    $fullscreen_navigation = (isset($GLOBALS['globax_enovathemes']['fullscreen-navigation']) && $GLOBALS['globax_enovathemes']['fullscreen-navigation'] == 1) ? "true" : "false";
                    $sticky_header         = (isset($GLOBALS['globax_enovathemes']['sticky-header']) && $GLOBALS['globax_enovathemes']['sticky-header'] == 1) ? "true" : "false";

                    $header_nav = ($sidebar_navigation == 'true' || $fullscreen_navigation == 'true') ? 'false' : 'true';

                    if ($sticky_header == "true" && $header_nav == 'true') {
                        $header_height         = (isset($GLOBALS['globax_enovathemes']['header-height']) && !empty($GLOBALS['globax_enovathemes']['header-height'])) ? $GLOBALS['globax_enovathemes']['header-height'] : "90";
                        $sticky_height         = (isset($GLOBALS['globax_enovathemes']['sticky-header-height']) && $GLOBALS['globax_enovathemes']['sticky-header-height']) ? $GLOBALS['globax_enovathemes']['sticky-header-height'] : "90";
                        $sticky_header         = (isset($GLOBALS['globax_enovathemes']['sticky-header']) && $GLOBALS['globax_enovathemes']['sticky-header'] == 1) ? "true" : "false";
                        $menu_under_logo       = (isset($GLOBALS['globax_enovathemes']['menu-under-logo']) && $GLOBALS['globax_enovathemes']['menu-under-logo'] == 1) ? "true" : "false";
                        $menu_under_logo_height = (isset($GLOBALS['globax_enovathemes']['menu-height']) && !empty($GLOBALS['globax_enovathemes']['menu-height'])) ? $GLOBALS['globax_enovathemes']['menu-height'] : "64";
                        
                        $offset = $sticky_height;
                        $from   = $header_height;

                        if ($menu_under_logo == "true") {
                           $offset = $menu_under_logo_height;
                           $from   = $menu_under_logo_height; 
                        }
                    }

                    if ($fullscreen_navigation == 'true') {
                        $fullscreen_height        = (isset($GLOBALS['globax_enovathemes']['fullscreen-height']) && $GLOBALS['globax_enovathemes']['fullscreen-height']) ? $GLOBALS['globax_enovathemes']['fullscreen-height'] : "90";
                        $fullscreen_sticky_height = (isset($GLOBALS['globax_enovathemes']['fullscreen-sticky-height']) && $GLOBALS['globax_enovathemes']['fullscreen-sticky-height']) ? $GLOBALS['globax_enovathemes']['fullscreen-sticky-height'] : $fullscreen_height;
                        $offset                   = $fullscreen_sticky_height;
                        $from                     = $fullscreen_height;
                    }

                    if (is_array($one_page_filter)) {
                        foreach ($one_page_filter as $filter) {
                            array_push($et_filter_array, '#'.$filter.' > a');
                        }
                    }

                    wp_enqueue_script( 'single-page-nav', GLOBAX_ENOVATHEMES_TEMPPATH.'/js/single-page-nav.js', array('jquery'), '', true);
                    wp_localize_script( 
                        'single-page-nav', 
                        'single_page_nav_opt', 
                        array(
                            'offset'      => $offset,
                            'from'        => $from,
                        )
                    );
                    wp_enqueue_script( 'one-page', GLOBAX_ENOVATHEMES_TEMPPATH.'/js/one-page.js', array('jquery'), '', true);
                    wp_localize_script( 
                        'one-page', 
                        'one_page_opt', 
                        array(
                            'navType'     => $one_page_nav, 
                            'offset'      => $offset,
                            'from'        => $from,
                            'speed'       => $one_page_speed,
                            'hash'        => $one_page_hash,
                            'filterArray' => (!empty($et_filter_array)) ? implode(', ', $et_filter_array) : ''
                        )
                    );

                }
            }

            // dequeue
            wp_dequeue_style( 'yith-wcwl-font-awesome' );
            wp_deregister_style( 'yith-wcwl-font-awesome' );
            wp_dequeue_style( 'woocommerce_prettyPhoto_css' );
            wp_deregister_style( 'woocommerce_prettyPhoto_css' );

        }

    }
    add_action( 'wp_enqueue_scripts', 'globax_enovathemes_script');

    function globax_admin_scripts_styles() {
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( 'wp-color-picker-alpha', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/wp-color-picker-alpha.min.js', array('wp-color-picker'), '', true);
        wp_enqueue_script('jquery-ui-core');
        wp_enqueue_style( 'adminstyle', GLOBAX_ENOVATHEMES_TEMPPATH . '/css/admin.css', false, '');
        wp_enqueue_script( 'adminscript', GLOBAX_ENOVATHEMES_TEMPPATH . '/js/admin.js', array('jquery'), '', true);
        wp_enqueue_media();
        return;
    }
    add_action('admin_enqueue_scripts','globax_admin_scripts_styles');

    function globax_enovathemes_editor_styles() {
        wp_enqueue_style('globax-default-fonts', '//fonts.googleapis.com/css?family=Montserrat:400,500,600,700|Roboto:400,500,700' );
        wp_enqueue_style( 'globax-editor-style', GLOBAX_ENOVATHEMES_TEMPPATH . '/css/editor-style.css' );

    }
    add_action( 'enqueue_block_editor_assets', 'globax_enovathemes_editor_styles' );
?>